% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information_criteria.R
\name{get_ic_vals}
\alias{get_ic_vals}
\title{Calculates the Information Criteria for a VAR, VARX, VARMA model}
\usage{
get_ic_vals(mod, verbose = TRUE)
}
\arguments{
\item{mod}{Model estimated Model estimated using \code{\link{sparseVAR}},
\code{\link{sparseVARX}}, or \code{\link{sparseVARMA}}}

\item{verbose}{Should information about the optimal selection be printed?}
}
\description{
The number of non-zero coefficients are taken as the degrees of freedom.
Use with care for VARMA.
}
\examples{
dat <- simVAR(periods=200, k=2, p=5, decay = 0.01)
mod <- sparseVAR(Y=scale(dat$Y))
ics <- get_ic_vals(mod)
}
