% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{block_size}
\alias{block_size}
\title{Determine a correct value for the block.size parameter}
\usage{
block_size(n, ncores = 1)
}
\arguments{
\item{n}{The number of rows.}

\item{ncores}{The number of cores.}
}
\value{
An integer >= 1.
}
\description{
It determines the value of \code{block.size} such that a matrix of doubles of
size \code{n} x \code{block.size} takes less memory than
\code{getOption("bigstatsr.block.sizeGB")} GigaBytes (default is 1GB).
}
\examples{
block_size(1e3)
block_size(1e6)
block_size(1e6, 6)
}
