% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparseSVM.R
\name{COPY_sparseSVM}
\alias{COPY_sparseSVM}
\title{Fit sparse linear SVM with lasso or elasti-net regularization}
\usage{
COPY_sparseSVM(X, y.train, ind.train, covar.train, alpha = 1, gamma = 0.1,
  nlambda = 100, lambda.min = if (nrow(X) > ncol(X)) 0.01 else 0.05, lambda,
  screen = c("ASR", "SR", "none"), max.iter = 1000, eps = 1e-05,
  dfmax = p + 1, penalty.factor = NULL, message = FALSE)
}
\arguments{
\item{alpha}{The elastic-net mixing parameter that controls the relative
contribution from the lasso and the ridge penalty. It must be a number
between \code{0} and \code{1}. \code{alpha=1} is the lasso penalty and \code{alpha=0}
the ridge penalty.}

\item{gamma}{The tuning parameter for huberization smoothing of hinge loss.
Default is \code{0.1}.}

\item{nlambda}{The number of lambda values. Default is \code{100}.}

\item{lambda.min}{The smallest value for lambda, as a fraction of
\code{lambda.max}, the data derived entry value. Default is \code{0.01} if the number
of observations is larger than the number of variables and \code{0.05} otherwise.}

\item{lambda}{A user-specified sequence of lambda values. Typical usage is
to leave blank and have the program automatically compute a \code{lambda}
sequence based on \code{nlambda} and \code{lambda.min}. Specifying
\code{lambda} overrides this. This argument should be used with care and
supplied with a decreasing sequence instead of a single value.}

\item{screen}{Screening rule to be applied at each \code{lambda} that
discards variables for speed. Either "ASR" (default), "SR" or "none". "SR"
stands for the strong rule, and "ASR" for the adaptive strong rule. Using
"ASR" typically requires fewer iterations to converge than "SR", but the
computing time are generally close. Note that the option "none" is used
mainly for debugging, which may lead to much longer computing time.}

\item{max.iter}{Maximum number of iterations. Default is 1000.}

\item{eps}{Convergence threshold. The algorithms continue until the maximum
change in the objective after any coefficient update is less than \code{eps}
times the null deviance.  Default is \code{1E-7}.}

\item{dfmax}{Upper bound for the number of nonzero coefficients. The
algorithm exits and returns a partial path if \code{dfmax} is reached.
Useful for very large dimensions.}

\item{penalty.factor}{A numeric vector of length equal to the number of
variables. Each component multiplies \code{lambda} to allow differential
penalization. Can be 0 for some variables, in which case the variable is
always in the model without penalization. Default is \code{1} for all variables.}

\item{message}{If set to \code{TRUE}, \code{sparseSVM} will inform the user of its
progress. Default is \code{FALSE}.}
}
\value{
A named list containing:
\item{call}{The call that produced this object.}
\item{intercept}{A vector of intercepts, corresponding to each lambda.}
\item{beta}{The fitted matrix of coefficients. The number of rows is
equal to the number of coefficients, and the number of columns is equal
to \code{nlambda}.}
\item{iter}{A vector of length \code{nlambda} containing the number of
iterations until convergence at each value of \code{lambda}.}
\item{saturated}{A logical flag for whether the number of nonzero
coefficients has reached \code{dfmax}.}
\item{lambda}{The sequence of regularization parameter values in the path.}
\item{alpha}{Input parameter.}
\item{gamma}{Input parameter.}
\item{penalty.factor}{Input parameter.}
\item{levels}{Levels of the output class labels.}
}
\description{
Fit solution paths for sparse linear SVM regularized by lasso or elastic-net
over a grid of values for the regularization parameter lambda.
}
\details{
The sequence of models indexed by the regularization parameter \code{lambda}
is fitted using a semismooth Newton coordinate descent algorithm. The
objective function is defined to be \deqn{\frac{1}{n} \sum hingeLoss(y_i
(x_i' w + b)) + \lambda\textrm{penalty}(w).}{\sum hingeLoss(y_i (x_i' w +
b))/n + \lambda*penalty(w).} where \deqn{hingeLoss(t) = max(0, 1-t)} and the
intercept \code{b} is unpenalized.
}
\keyword{internal}
