% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bq-table.R
\name{api-table}
\alias{api-table}
\alias{bq_table_create}
\alias{bq_table_meta}
\alias{bq_table_fields}
\alias{bq_table_size}
\alias{bq_table_nrow}
\alias{bq_table_exists}
\alias{bq_table_delete}
\alias{bq_table_copy}
\alias{bq_table_upload}
\alias{bq_table_save}
\alias{bq_table_load}
\alias{bq_table_patch}
\title{BigQuery tables}
\usage{
bq_table_create(x, fields = NULL, ...)

bq_table_meta(x, fields = NULL)

bq_table_fields(x)

bq_table_size(x)

bq_table_nrow(x)

bq_table_exists(x)

bq_table_delete(x)

bq_table_copy(x, dest, ..., quiet = NA)

bq_table_upload(x, values, ..., quiet = NA)

bq_table_save(x, destination_uris, ..., quiet = NA)

bq_table_load(x, source_uris, ..., quiet = NA)

bq_table_patch(x, fields)
}
\arguments{
\item{x}{A \link{bq_table}, or an object coercible to a \code{bq_table}.}

\item{fields}{A \link{bq_fields} specification, or something coercible to it
(like a data frame).}

\item{...}{Additional arguments passed on to the underlying API call.
snake_case names are automatically converted to camelCase.}

\item{dest}{Source and destination \link{bq_table}s.}

\item{quiet}{If \code{FALSE}, displays progress bar; if \code{TRUE} is silent;
if \code{NA} displays progress bar only for long-running jobs.}

\item{values}{Data frame of values to insert.}

\item{destination_uris}{A character vector of fully-qualified Google Cloud
Storage URIs where the extracted table should be written. Can export
up to 1 Gb of data per file. Use a wild card URI (e.g.
\verb{gs://[YOUR_BUCKET]/file-name-*.json}) to automatically create any
number of files.}

\item{source_uris}{The fully-qualified URIs that point to your data in
Google Cloud.

For Google Cloud Storage URIs: Each URI can contain one
`'*'`` wildcard character and it must come after the 'bucket' name.
Size limits related to load jobs apply to external data sources.

For Google Cloud Bigtable URIs: Exactly one URI can be specified and
it has be a fully specified and valid HTTPS URL for a Google Cloud
Bigtable table. For Google Cloud Datastore backups: Exactly one URI
can be specified. Also, the '*' wildcard character is not allowed.}
}
\value{
\itemize{
\item \code{bq_table_copy()}, \code{bq_table_create()}, \code{bq_table_delete()}, \code{bq_table_upload()}:
an invisible \link{bq_table}
\item \code{bq_table_exists()}: either \code{TRUE} or \code{FALSE}.
\item \code{bq_table_download()}: a data frame
\item \code{bq_table_size()}: the size of the table in bytes
\item \code{bq_table_fields()}: a \link{bq_fields}.
}
}
\description{
Basic create-read-update-delete verbs for tables, as well as functions
for uploading and downloading data in to/from memory (\code{bq_table_upload()},
(\code{bq_table_download()})), and saving to/loading from Google CloudStorage
(\code{bq_table_load()}, \code{bq_table_save()}).
}
\section{API documentation}{

\itemize{
\item \href{https://cloud.google.com/bigquery/docs/reference/rest/v2/tables/insert}{insert}
\item \href{https://cloud.google.com/bigquery/docs/reference/rest/v2/tables/get}{get}
\item \href{https://cloud.google.com/bigquery/docs/reference/rest/v2/tables/delete}{delete}
}
}

\examples{
if (bq_testable()) {
ds <- bq_test_dataset()

bq_mtcars <- bq_table_create(
  ds,
  "mtcars",
  friendly_name = "Motor Trend Car Road Tests",
  description = "The data was extracted from the 1974 Motor Trend US magazine",
  labels = list(category = "example")
)
bq_mtcars <- bq_table(ds, "mtcars")
bq_table_exists(bq_mtcars)

bq_table_upload(bq_mtcars, mtcars)
bq_table_exists(bq_mtcars)

bq_table_fields(bq_mtcars)
bq_table_size(bq_mtcars)
str(bq_table_meta(bq_mtcars))

bq_table_delete(bq_mtcars)
bq_table_exists(bq_mtcars)

my_natality <- bq_table(ds, "mynatality")
bq_table_copy("publicdata.samples.natality", my_natality)
}
}
