% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.r
\name{copy_table}
\alias{copy_table}
\title{Copy one or more source tables to a destination table.}
\usage{
copy_table(src, dest, create_disposition = "CREATE_IF_NEEDED",
  write_disposition = "WRITE_EMPTY", project = NULL, ...)
}
\arguments{
\item{src}{either a single table reference, or a list of table references}

\item{dest}{destination table}

\item{create_disposition}{behavior for table creation if the destination
already exists. defaults to \code{"CREATE_IF_NEEDED"},
the only other supported value is \code{"CREATE_NEVER"}; see
\href{https://cloud.google.com/bigquery/docs/reference/v2/jobs#configuration.copy.createDisposition}{the API documentation}
for more information}

\item{write_disposition}{behavior for writing data if the destination already
exists. defaults to \code{"WRITE_EMPTY"}, other possible values are
\code{"WRITE_TRUNCATE"} and \code{"WRITE_APPEND"}; see
\href{https://cloud.google.com/bigquery/docs/reference/v2/jobs#configuration.copy.writeDisposition}{the API documentation}
for more information}

\item{project}{project ID to use for the copy job. defaults to the project of
the destination table.}

\item{...}{Additional arguments merged into the body of the
request. \code{snake_case} will automatically be converted into
\code{camelCase} so you can use consistent argument names.}
}
\description{
Each source table and the destination table should be table references, that
is, lists with exactly three entries: \code{project_id}, \code{dataset_id},
and \code{table_id}.
}
\examples{
\dontrun{
src <- list(project_id = "publicdata", dataset_id = "samples", table_id = "shakespeare")
dest <- list(project_id = "myproject", dataset_id = "mydata", table_id = "shakespeare")
doubled <- dest
doubled$table_id <- "double_shakespeare"
copy_table(src, dest)
copy_table(list(src, dest), doubled)
}
}
\seealso{
API documentation:
\url{https://cloud.google.com/bigquery/docs/tables#copyingtable}
}
