% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbi-driver.r, R/dbi-connection.r, R/dbi-result.r
\docType{class}
\name{DBI}
\alias{BigQueryConnection-class}
\alias{BigQueryDriver-class}
\alias{BigQueryResult-class}
\alias{DBI}
\alias{dbBegin,BigQueryConnection-method}
\alias{dbBind,BigQueryResult-method}
\alias{dbClearResult,BigQueryResult-method}
\alias{dbColumnInfo,BigQueryResult-method}
\alias{dbCommit,BigQueryConnection-method}
\alias{dbConnect,BigQueryDriver-method}
\alias{dbDisconnect,BigQueryConnection-method}
\alias{dbExistsTable,BigQueryConnection,character-method}
\alias{dbFetch,BigQueryResult-method}
\alias{dbGetInfo,BigQueryConnection-method}
\alias{dbGetInfo,BigQueryDriver-method}
\alias{dbGetRowCount,BigQueryResult-method}
\alias{dbGetRowsAffected,BigQueryResult-method}
\alias{dbGetStatement,BigQueryResult-method}
\alias{dbHasCompleted,BigQueryResult-method}
\alias{dbIsValid,BigQueryConnection-method}
\alias{dbIsValid,BigQueryDriver-method}
\alias{dbIsValid,BigQueryResult-method}
\alias{dbListFields,BigQueryConnection,character-method}
\alias{dbListTables,BigQueryConnection-method}
\alias{dbQuoteIdentifier,BigQueryConnection,character-method}
\alias{dbQuoteString,BigQueryConnection,character-method}
\alias{dbReadTable,BigQueryConnection,character-method}
\alias{dbRemoveTable,BigQueryConnection,character-method}
\alias{dbRollback,BigQueryConnection-method}
\alias{dbSendQuery,BigQueryConnection,character-method}
\alias{dbWriteTable,BigQueryConnection,character,data.frame-method}
\alias{show,BigQueryConnection-method}
\alias{show,BigQueryDriver-method}
\alias{show,BigQueryResult-method}
\title{DBI methods}
\usage{
\S4method{show}{BigQueryDriver}(object)

\S4method{dbConnect}{BigQueryDriver}(drv, project, dataset, billing = project,
  ...)

\S4method{dbIsValid}{BigQueryDriver}(dbObj, ...)

\S4method{dbGetInfo}{BigQueryDriver}(dbObj, ...)

\S4method{show}{BigQueryConnection}(object)

\S4method{dbIsValid}{BigQueryConnection}(dbObj, ...)

\S4method{dbDisconnect}{BigQueryConnection}(conn, ...)

\S4method{dbSendQuery}{BigQueryConnection,character}(conn, statement, ...)

\S4method{dbQuoteString}{BigQueryConnection,character}(conn, x, ...)

\S4method{dbQuoteIdentifier}{BigQueryConnection,character}(conn, x, ...)

\S4method{dbWriteTable}{BigQueryConnection,character,data.frame}(conn, name,
  value, overwrite = FALSE, append = FALSE, ..., row.names = NA)

\S4method{dbReadTable}{BigQueryConnection,character}(conn, name, ...,
  row.names = NA)

\S4method{dbListTables}{BigQueryConnection}(conn, ...)

\S4method{dbExistsTable}{BigQueryConnection,character}(conn, name, ...)

\S4method{dbListFields}{BigQueryConnection,character}(conn, name, ...)

\S4method{dbRemoveTable}{BigQueryConnection,character}(conn, name, ...)

\S4method{dbGetInfo}{BigQueryConnection}(dbObj, ...)

\S4method{dbBegin}{BigQueryConnection}(conn, ...)

\S4method{dbCommit}{BigQueryConnection}(conn, ...)

\S4method{dbRollback}{BigQueryConnection}(conn, ...)

\S4method{show}{BigQueryResult}(object)

\S4method{dbIsValid}{BigQueryResult}(dbObj, ...)

\S4method{dbClearResult}{BigQueryResult}(res, ...)

\S4method{dbFetch}{BigQueryResult}(res, n = -1, ..., row.names = NA)

\S4method{dbHasCompleted}{BigQueryResult}(res, ...)

\S4method{dbGetStatement}{BigQueryResult}(res, ...)

\S4method{dbColumnInfo}{BigQueryResult}(res, ...)

\S4method{dbGetRowCount}{BigQueryResult}(res, ...)

\S4method{dbGetRowsAffected}{BigQueryResult}(res, ...)

\S4method{dbBind}{BigQueryResult}(res, params, ...)
}
\arguments{
\item{object}{Any R object}

\item{drv}{an object that inherits from \code{\linkS4class{DBIDriver}}, or
a character string specifying the name of DBMS driver, e.g., "RSQLite",
"RMySQL", "RPostgreSQL", or an existing \code{\linkS4class{DBIConnection}}
object (in order to clone an existing connection).}

\item{project}{project containing this table}

\item{dataset}{dataset containing this table}

\item{billing}{project ID to use for billing}

\item{...}{authorization arguments needed by the DBMS instance; these
typically include \code{user}, \code{password}, \code{dbname}, \code{host},
\code{port}, etc.  For details see the appropriate \code{DBIDriver}.}

\item{dbObj}{An object inheriting from \code{\linkS4class{DBIObject}},
i.e. \code{\linkS4class{DBIDriver}}, \code{\linkS4class{DBIConnection}},
or a \code{\linkS4class{DBIResult}}}

\item{conn}{A \code{\linkS4class{DBIConnection}} object, as produced by
\code{\link{dbConnect}}.}

\item{statement}{a character vector of length 1 containing SQL.}

\item{x}{A character vector to label as being escaped SQL.}

\item{name}{A character string specifying a DBMS table name.}

\item{value}{a data.frame (or coercible to data.frame).}

\item{overwrite}{a logical specifying whether to overwrite an existing table
or not. Its default is \code{FALSE}.}

\item{append}{a logical specifying whether to append to an existing table
in the DBMS.  Its default is \code{FALSE}.}

\item{row.names}{A logical specifying whether the \code{row.names} should be
output to the output DBMS table; if \code{TRUE}, an extra field whose name
will be whatever the R identifier \code{"row.names"} maps to the DBMS (see
\code{\link[DBI]{make.db.names}}). If \code{NA} will add rows names if
they are characters, otherwise will ignore.}

\item{res}{An object inheriting from \code{\linkS4class{DBIResult}}.}

\item{n}{maximum number of records to retrieve per fetch. Use \code{n = -1}
to retrieve all pending records.  Some implementations may recognize other
special values.}

\item{params}{A list of bindings. Named values should be matched to
named paramters (if supported by the DBI backend). Unnamed values
will be matched by position. I don't recommend mixing named and unnamed
values.}
}
\description{
Implementations of pure virtual functions defined in the \code{DBI} package.
}

