% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.r
\name{get_table}
\alias{exists_table}
\alias{get_table}
\title{Retrieve table metadata}
\usage{
get_table(project, dataset, table)

exists_table(project, dataset, table)
}
\arguments{
\item{project}{project containing this table}

\item{dataset}{dataset containing this table}

\item{table}{name of the table}
}
\value{
A table resource list, as described by
 \url{https://developers.google.com/bigquery/docs/reference/v2/tables}
}
\description{
\code{get_table} returns a table's metadata as a nested list.
  In addition to a regular error, the condition \code{bigrquery_notFound}
  (which can be handled via \code{\link[base]{tryCatch}})
  is raised if the table could not be found.

\code{exists_table} merely checks if a table exists, and returns
  either \code{TRUE} or \code{FALSE}.
}
\examples{
\dontrun{
get_table("publicdata", "samples", "natality")
get_table("githubarchive", "github", "timeline")
}

}
\seealso{
API documentation:
 \url{https://developers.google.com/bigquery/docs/reference/v2/tables/get}

Other tables: \code{\link{delete_table}},
  \code{\link{list_tables}}
}

