% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigpca.R
\name{get.big.matrix}
\alias{get.big.matrix}
\title{Retrieve a big.matrix object}
\usage{
get.big.matrix(fn, dir = "", verbose = FALSE)
}
\arguments{
\item{fn}{the name of a description file, the name of a binary file containing a
big.matrix.descriptor, a big.matrix object or a big.matrix.descriptor object.}

\item{dir}{directory containing the backing file (if not the working directory)}

\item{verbose}{whether to display information on method being used, or minor warnings}
}
\value{
Returns a big.matrix object, regardless of what method was used as reference/input
}
\description{
This function can load a big.matrix object using a big.matrix.descriptor object, the
name of a description file, the name of a binary file containing a big.matrix.descriptor
or if passed a big.matrix object, it will just return that object. Only the object or
file name plus the directory containing the backing file are required.
}
\examples{
# set up a toy example of a big.matrix 
orig.dir <- getwd(); setwd(tempdir()); # move to temporary dir
if(file.exists("test.bck")) { unlink(c("test.bck","test.dsc")) }
bM <- filebacked.big.matrix(20, 50,
       dimnames = list(paste("r",1:20,sep=""), paste("c",1:50,sep="")),
       backingfile = "test.bck",  backingpath = getwd(), descriptorfile = "test.dsc")
bM[1:20,] <- replicate(50,rnorm(20))
# Now have a big matrix which can be retrieved using this function in 4 ways:
d.bM <- describe(bM)
save(d.bM,file="fn.RData")
bM1 <- get.big.matrix("test.dsc")
bM2 <- get.big.matrix(d.bM)
bM3 <- get.big.matrix("fn.RData")
bM4 <- get.big.matrix(bM)
prv.big.matrix(bM)
prv.big.matrix(bM1)
prv.big.matrix(bM2)
prv.big.matrix(bM3)
prv.big.matrix(bM4)
rm(bM) 
unlink(c("fn.RData","test.bck","test.dsc"))
setwd(orig.dir)
}
