% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdm_main.R
\name{bdm.scp}
\alias{bdm.scp}
\title{Transfer \var{bdm} instance to a remote machine.}
\usage{
bdm.scp(..., dest = NULL)
}
\arguments{
\item{...}{A \var{bdm} instance as generated by \code{bdm.init()}.}

\item{dest}{The name or IP address of a remote machine where to transfer the file of the \var{bdm} instance. By default is send to \var{bdm.local()} environment variable.}
}
\value{
None
}
\description{
Transfers a \var{bdm} instance to a remote machine. By default a file name is generated based on \code{bdm$dSet} and t-SNE main parameters (threads, layers, rounds, perplexity). The purpose of functions \code{bdm.save()} and \code{bdm.scp()} used with \code{bdm.fName()} is to ease the task of working/organizing multiple runs on the same dataset.
}
\examples{

\dontrun{
# --- load example
bdm.example()
# --- scp to \\var{bdm.local()} with default file name
bdm.scp(exMap)
# --- scp to IP address 'xxx.xxx.0.0' with default file name
bdm.scp(exMap, dest = 'xxx.xxx.0.0')
}
}
