% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfa.ls.R
\name{bfa.ls}
\alias{bfa.ls}
\title{Least Squares Estimation of Bifurcating Autoregressive Models}
\usage{
bfa.ls(
  z,
  p,
  x.data = FALSE,
  y.data = FALSE,
  resids = FALSE,
  error.cor = TRUE,
  error.var = FALSE,
  cov.matrix = FALSE,
  conf = FALSE,
  conf.level = 0.95,
  B = 49,
  p.value = FALSE
)
}
\arguments{
\item{z}{a numeric vector containing the tree data}

\item{p}{an integer determining the order of bifurcating autoregressive model
to be fit to the data}

\item{x.data}{a logical that determines whether the x data used in fitting
the model should be returned. Defaults to FALSE.}

\item{y.data}{a logical that determines whether the y data used in fitting
the model should be returned. Defaults to FALSE.}

\item{resids}{a logical that determines whether the model residuals should be
returned. Defaults to FALSE.}

\item{error.cor}{a logical that determines whether the estimated correlation
between pairs of model errors \eqn{(e_{2t}, e_{2t+1})} should be returned.
Defaults to TRUE.}

\item{error.var}{a logical that determines whether the estimated variance of
the model errors should be returned. Defaults to FALSE.}

\item{cov.matrix}{a logical that determines whether the estimated
variance-covariance matrix of the least squares estimates should be
returned. Defaults to FALSE.}

\item{conf}{a logical that determines whether confidence intervals for model
coefficients should be returned. Defaults to FALSE. If TRUE, asymptotic normal
confidence intervals for the intercept and the slops are calculated using
\code{cov.matrix}. In addition, normal bootstrap confidence interval, and
percentile confidence interval for the slop are calculated.}

\item{conf.level}{confidence level to be used in computing the normal
confidence intervals for model coefficients when \code{conf=TRUE}. Defaults
to \code{0.95}.}

\item{B}{number of bootstrap samples (replicates)}

\item{p.value}{a logical that determines whether p-values for model
coefficients should be returned. Defaults to FALSE. If TRUE, p-values are
computed from normal distribution using estimated coefficients and
\code{cov.matrix}.}
}
\value{
\item{coef}{a matrix containing the least squares estimates of the
autoregressive coefficients} \item{error.cor}{the least squares estimate of
the correlation between pairs of model errors \eqn{(e_{2t}, e_{2t+1})}.
Only returned if \code{error.cor=TRUE}} \item{x}{a matrix containing the x
data used in fitting the model. Only returned if \code{x.data=TRUE}}
\item{y}{a vector containing the y data used in fitting the model. Only
returned if \code{y.data=TRUE}} \item{resids}{the model residuals. Only
returned if \code{resids=TRUE}} \item{error.var}{the estimated variance of
the model errors. Only returned if \code{error.var=TRUE}}
\item{cov.matrix}{the estimated variance-covariance matrix of the least
squares coefficients. Only returned if \code{cov.matrix=TRUE}}\item{conf}{a
matrix of normal confidence intervals for model coefficients. Only returned
if \code{conf=TRUE}}\item{p.value}{a matrix of two-sided p-values for
testing the significance of model coefficients. Computed from normal
distribution and using the estimated covariance matrix \code{cov.matrix}.
Only returned if \code{p.value=TRUE}}
}
\description{
This function performs Least Squares estimation of bifurcating autoregressive
(BFA) models of any order as described in Zhou and Basawa (2005).
}
\examples{
z <- bfa.tree.gen(127, 1, 1, 1, -0.9, -0.9, 0, 10, c(0.7))
bfa.ls(z, p=1)
bfa.ls(z,p=1,conf=TRUE,cov.matrix = TRUE,conf.level = 0.9,p.value=TRUE)
}
\references{
Zhou, J. & Basawa, I. V. (2005). Least squares estimation for
bifurcating autoregressive processes. \emph{Statistics & Probability
Letters}, 74(1):77-88.
}
