% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cocMatrix.R
\name{cocMatrix}
\alias{cocMatrix}
\title{Co-occurrence matrix}
\usage{
cocMatrix(M, Field = "AU", type = "sparse", n = NULL, sep = ";", binary = TRUE)
}
\arguments{
\item{M}{is a data frame obtained by the converting function
\code{\link{convert2df}}. It is a data matrix with cases corresponding to
articles and variables to Field Tag in the original WoS or SCOPUS file.}

\item{Field}{is a character object. It indicates one of the field tags of the
  standard ISI WoS Field Tag codify. Field can be equal to one of these tags:
  \tabular{lll}{ \code{AU}\tab   \tab Authors\cr \code{SO}\tab   \tab
  Publication Name (or Source)\cr \code{JI}\tab   \tab ISO Source
  Abbreviation\cr \code{DE}\tab   \tab Author Keywords\cr \code{ID}\tab
  \tab Keywords associated by WoS or SCOPUS database \cr \code{CR}\tab   \tab
  Cited References}

  for a complete list of filed tags see:
  \href{http://www.bibliometrix.org/documents/Field_Tags_bibliometrix.pdf}{Field Tags used in bibliometrix}\cr\cr}

\item{type}{indicates the output format of co-occurrences: \tabular{lll}{
\code{type = "matrix"} \tab   \tab produces an object of class
\code{matrix}\cr \code{type = "sparse"} \tab   \tab produces an object of
class \code{dgMatrix} of the package \code{\link{Matrix}}. "sparse"
argument generates a compact representation of the matrix.}}

\item{n}{is an integer. It indicates the number of items to select. If \code{N = NULL}, all items are selected.}

\item{sep}{is the field separator character. This character separates strings in each 
column of the data frame. The default is \code{sep = ";"}.}

\item{binary}{is a logical. If TRUE each cell contains a 0/1. if FALSE each cell contains the frequency.}
}
\value{
a co-occurrence matrix with cases corresponding to manuscripts and variables to the
  objects extracted from the Tag \code{Field}.
}
\description{
\code{cocMatrix} computes co-occurences between elements of a Tag Field from a bibliographic data frame. Manuscript is the unit of analysis.
}
\details{
This co-occurrence matrix can be transformed into a collection of compatible
networks. Through matrix multiplication you can obtain different networks. 
The function follows the approach proposed by Batagelj & Cerinsek (2013) and Aria & cuccurullo (2017).\cr\cr

References:\cr
Batagelj, V., & Cerinsek, M. (2013). On bibliographic networks. Scientometrics, 96(3), 845-864.\cr
Aria, M., & Cuccurullo, C. (2017). bibliometrix: An R-tool for comprehensive science mapping analysis. Journal of Informetrics, 11(4), 959-975.\cr
}
\examples{
# EXAMPLE 1: Articles x Authors co-occurrence matrix

data(scientometrics)
WA <- cocMatrix(scientometrics, Field = "AU", type = "sparse", sep = ";")

# EXAMPLE 2: Articles x Cited References co-occurrence matrix

# data(scientometrics)

# WCR <- cocMatrix(scientometrics, Field = "CR", type = "sparse", sep = ";")

# EXAMPLE 3: Articles x Cited First Authors co-occurrence matrix

# data(scientometrics)
# scientometrics <- metaTagExtraction(scientometrics, Field = "CR_AU", sep = ";")
# WCR <- cocMatrix(scientometrics, Field = "CR_AU", type = "sparse", sep = ";")

}
\seealso{
\code{\link{convert2df}} to import and convert an ISI or SCOPUS
  Export file in a data frame.

\code{\link{biblioAnalysis}} to perform a bibliometric analysis.

\code{\link{biblioNetwork}} to compute a bibliographic network.
}
