% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clearanceEstimatorBayes.R
\name{clearanceEstimatorBayes}
\alias{clearanceEstimatorBayes}
\title{Bayesian Hierarchical Regression on Clearance Rates}
\usage{
clearanceEstimatorBayes(data, covariates = NULL, seed = 1234,
  detect.limit = 40, outlier.detect = TRUE, conf.level = 0.95,
  niteration = 1e+05, burnin = 500, thin = 50, filename = "output.csv")
}
\arguments{
\item{data}{a data frame containing the profiles of patients.
This data frame must contain \code{id}, \code{time}, and \code{count} columns, 
in that order. The first column represents the IDs of patients. 
The second and third columns contain parasite measurements (per microliter) in different times.}

\item{covariates}{an optional data frame containing individual level covaraites. This argument may be \code{NULL}, 
in which case estimation of clearance rates is of primary interest.}

\item{seed}{a user-sepcified number used to initialize a pseudorandom number generator. 
The default value is set to be 1234 for reproducibility. If \code{seed = NULL}, then its value will be 
automatically obtained from the system clock.}

\item{detect.limit}{detection limit of the parasite density in blood (parasites per microliter)}

\item{outlier.detect}{indicator of whether or not to use Flegg's outlier detection method.
\code{outlier.detect = TRUE} is recommended.}

\item{conf.level}{required confidence level for reporting credible intervals}

\item{niteration}{total number of simulations after the burn-in period}

\item{burnin}{length of the burn-in priod in the MCMC used in \code{clearanceEstimatorBayes}}

\item{thin}{step size of the thinning process in the MCMC used in \code{clearanceEstimatorBayes}}

\item{filename}{the name of the csv file used to store some output elements. This file contains
\code{id}, \code{clearance.mean}, \code{lag.median}, and \code{tail.median}.}
}
\value{
The function \link{summary} (i.e., \link{summary.bhrcr}) can be used to obtain a summary of the results.
\code{clearanceEstimatorBayes} returns an object of class "bhrcr" which is a list containing:
\item{CALL}{function call}
\item{clearance.post}{posterior distributions of clearance rates}
\item{clearance.mean}{mean values of the posterior distributions of clearance rates}
\item{clearance.median}{median values of the posterior distributions of clearance rates}
\item{intercept.post}{posterior distributions of the intercepts (alpha_i's) in the model}
\item{gamma.post}{posterior distribution of gamma}
\item{gamma.post.thin}{thinned posterior sample of gamma}
\item{gamma.mean}{mean values of the posterior distribution of gamma}
\item{gamma.median}{median values of the posterior distribution of gamma}
\item{gamma.CI}{Credible intervals for gamma}
\item{halflifeslope.post}{posterior distribution for the effect of covariates on log half-lives}
\item{halflifeslope.mean}{mean values of the posterior distribution for the effect of covariates on log half-lives}
\item{halflifeslope.median}{median values of the posterior distribution for the effect of covariates on log half-lives}
\item{halflifeslope.CI}{Credible intervals for the effect of covariates on log half-lives}
\item{predicted.pce}{PCE estimates}
\item{eta.post}{posterior distribution of eta}
\item{changelag.post}{posterior distributions of changetime between lag and decay phases}
\item{changetail.post}{posterior distributions of changetime between decay and tail phases}
\item{lag.median}{median values of the posterior distributions of changetime between lag and decay phases}
\item{tail.median}{median values of the posterior distributions of changetime between decay and tail phases}
\item{var.epsilon.post}{posterior variance of epsilon after simulation}
\item{var.error.post}{thinned posterior sample of variance of epsilon}
\item{var.alpha.post}{posterior distribution of variance of alpha}
\item{var.beta.post}{posterior distribution of variance of beta}
\item{index}{a list containing each patient's indices in the data}
\item{counts}{Original parasite counts of all patients}
\item{counts.current}{Parasite counts of all patients after sampling censored measurements}
\item{t.overall}{measurement times of all patients}
\item{p.lag}{posterior value of the priori probability of there being a lag phase after simulation}
\item{p.lag.thin}{thinned posterior sample of the priori probability of there being a lag phase}
\item{p.tail}{posterior value of the priori probability of there being a tail phase after simulation}
\item{p.tail.thin}{thinned posterior sample of the priori probability of there being a tail phase}
\item{var1.post}{posterior distribution of c^2}
\item{var2.post}{posterior distribution of d^2}
\item{mu1.post}{posterior distribution of a}
\item{mu2.post}{posterior distribution of b}
\item{detect.limit}{the detection limit of parasitemia}
\item{lag.post}{posterior distributions of index of changetime between lag and decay phases}
\item{lag2.post}{posterior distributions of index of changetime between decay and tail phases}
\item{theta.post}{posterior distributions of log-parasite-count's mean in lag phase}
\item{theta2.post}{posterior distributions of log-parasite-count's mean in tail phase}
\item{burnin}{length of the burn-in period}
}
\description{
\code{clearanceEstimatorBayes} estimates the parasite clearance rates by using a Bayesian hierarchical model. 
Moreoever, it provides regression analysis of clearance rates on given covariates.
}
\details{
This function estimates parasite clearance rates, along with the effect of covariates on them, 
by using the Bayesian hierarchical model which was introduced in Fogarty et al. (2015). 
A change point model is used on the log of the parasite densities to account for three potential phases: 
(1) a constant phase (the lag phase); (2) a phase with a linear decrease (decay phase); 
(3) another constant phase (the tail phase). Hence the estimation of the parasite clearance rate is only 
based on observations within the decay phase. The Bayesian approach allows us to treat the delineation between
lag, decay, and tail phases within an individual's clearance profile as themselves being random variables,
thus taking into account the additional uncertainty of boundaries between phases.
Details are in Fogarty et al. (2015).
}
\examples{
\dontshow{
data("pursat")
data("pursat_covariates")
data = pursat[pursat["id"] <= 80 & pursat["id"] > 70,]
covariates = pursat_covariates[71:80,]
out <- clearanceEstimatorBayes(data = data, covariates = covariates, outlier.detect = TRUE,
                              niteration = 3, burnin = 1, thin = 1)
}
\donttest{
data("pursat")
data("pursat_covariates")
out <- clearanceEstimatorBayes(data = pursat, covariates = pursat_covariates, outlier.detect = TRUE,
                               niteration = 200, burnin = 50, thin = 10)
}

}
\references{
Flegg, J. A., Guerin, P. J., White, N. J., & Stepniewska, K. (2011). 
Standardizing the measurement of parasite clearance in falciparum malaria: the parasite clearance estimator. 
Malaria journal, 10(1), 339.

Fogarty, C. B., Fay, M. P., Flegg, J. A., Stepniewska, K., Fairhurst, R. M., & Small, D. S. (2015). 
Bayesian hierarchical regression on clearance rates in the presence of "lag" and "tail" phases 
with an application to malaria parasites. Biometrics, 71(3), 751-759.
}
\author{
Colin B. Fogarty <cfogarty@mit.edu>, Saeed Sharifi-Malvajerdi <saeedsh@wharton.upenn.edu>, Feiyu Zhu <feiyuzhu@sas.upenn.edu>
}
