% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{ReadFile}
\alias{ReadFile}
\title{Read File}
\usage{
ReadFile(
  file = NULL,
  path = "models/",
  package = "bfw",
  type = "string",
  sep = ",",
  data.format = "txt",
  custom = FALSE
)
}
\arguments{
\item{file}{name of file, Default: NULL}

\item{path}{path to file, Default: 'models/'}

\item{package}{choose package to open from, Default: 'bfw'}

\item{type}{Type of file (i.e., text or data), Default: 'string'}

\item{sep}{symbol to separate data (e.g., comma-delimited), Default: ','}

\item{data.format}{define what data format is being used, Default: 'csv'}

\item{custom}{logical, indicating whether or not to use custom file, , Default: FALSE}
}
\description{
opens connection to a file
}
\examples{
# Print JAGS model for bernoulli trials
cat(ReadFile("stats_bernoulli"))
# model {
#   for (i in 1:n){
#     x[i] ~ dbern(theta)
#   }
#   theta ~ dunif(0,1)
# }
}
\seealso{
\code{\link[utils]{read.csv}}
}
