% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaMC-methods-beta-mc.R
\name{summary.betamc}
\alias{summary.betamc}
\title{Summary Method for an Object of Class
\code{betamc}}
\usage{
\method{summary}{betamc}(object, alpha = c(0.05, 0.01, 0.001), digits = 4, ...)
}
\arguments{
\item{object}{Object of Class \code{betamc},
that is,
the output of the
\code{BetaMC()},
\code{RSqMC()},
\code{SCorMC()},
\code{DeltaRSqMC()},
\code{PCorMC()}, or
\code{DiffBetaMC()}
functions.}

\item{alpha}{Significance level.}

\item{digits}{Digits to print.}

\item{...}{additional arguments.}
}
\value{
Returns a matrix of
estimates,
standard errors,
number of Monte Carlo replications,
and
confidence intervals.
}
\description{
Summary Method for an Object of Class
\code{betamc}
}
\examples{
# Fit the regression model
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
# Generate the sampling distribution of parameter estimates
# (use a large R, for example, R = 20000 for actual research)
mc <- MC(object, R = 100)
# Generate confidence intervals for standardized regression slopes
std <- BetaMC(mc)
# Method ---------------------------------------------------------
summary(std)
}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
