% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaMC-methods-beta-mc.R
\name{confint.betamc}
\alias{confint.betamc}
\title{Confidence Intervals Method for an Object of Class
\code{betamc}}
\usage{
\method{confint}{betamc}(object, parm = NULL, level = 0.95, ...)
}
\arguments{
\item{object}{Object of Class \code{betamc},
that is,
the output of the
\code{BetaMC()},
\code{RSqMC()},
\code{SCorMC()},
\code{DeltaRSqMC()},
\code{PCorMC()}, or
\code{DiffBetaMC()}
functions.}

\item{parm}{a specification of which parameters
are to be given confidence intervals,
either a vector of numbers or a vector of names.
If missing, all parameters are considered.}

\item{level}{the confidence level required.}

\item{...}{additional arguments.}
}
\value{
Returns a matrix of confidence intervals.
}
\description{
Confidence Intervals Method for an Object of Class
\code{betamc}
}
\examples{
# Fit the regression model
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
# Generate the sampling distribution of parameter estimates
# (use a large R, for example, R = 20000 for actual research)
mc <- MC(object, R = 100)
# Generate confidence intervals for standardized regression slopes
std <- BetaMC(mc)
# Method ---------------------------------------------------------
confint(std, level = 0.95)
}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
