% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/if.error.R
\name{if.error}
\alias{if.error}
\title{expressions/values conditional on whether tested expression returns an error.}
\usage{
if.error(expr, error_true, error_false)
}
\arguments{
\item{expr}{Expression to be tested for returning an error.}

\item{error_true}{Value or expression to be executed if tested expression returns an error.}

\item{error_false}{Value or expression to be executed if tested expression does not return an error.}
}
\value{
Returns value or expression stated in \code{error_true} or \code{error_false},
 depending on whether the tested expression throws an error.
}
\description{
Does a given expression return an error? 
Return specific values/expressions for either case.
Useful for loops when you want to easily control values based on errors that arise.
}
\examples{
if.error(  log(3),   "error", "no_error" )
if.error(  log(3),   "error", log(3)  )
if.error(  log(3),   log(6), "no_error" )
if.error(  log("a"), log(6), log(3) )

}
\seealso{
\code{\link{is.error}}
}
\author{
Nick Bultman, \email{njbultman74@gmail.com}, September 2020
}
\keyword{error}
\keyword{programming}
