% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testExamples.R
\name{testExamples}
\alias{testExamples}
\title{Test examples in a package}
\usage{
testExamples(path = packagePath("."), commentDontrun = FALSE,
  selection = NULL, logfolder = "ExampleTestLogs",
  elogfile = "errors.txt", wlogfile = "warnings.txt",
  tlogfile = "times.txt", plotfile = "plots.pdf",
  tellcurrentfile = TRUE, ...)
}
\arguments{
\item{path}{Path to package. For internal function \code{testExample}, 
path to a single Rd file.
DEFAULT: \code{\link{packagePath}(".")}}

\item{commentDontrun}{Logical. Should \\dontrun sections be excluded?
DEFAULT: FALSE}

\item{selection}{Optional: selection of files, e.g 1:10. DEFAULT: NULL}

\item{logfolder}{Directory where to store the logfiles. Created if not 
existing. DEFAULT: "ExampleTestLogs"}

\item{elogfile}{File to log errors in. (Appended to existing text). 
DEFAULT: "errors.txt"}

\item{wlogfile}{File to log warnings and messages in. (Appended to existing text). 
DEFAULT: "warnings.txt"}

\item{tlogfile}{File in which to write computing times. 
DEFAULT: "times.txt"}

\item{plotfile}{File to log warnings and messages in. (Appended to existing text). 
DEFAULT: "plots.pdf"}

\item{tellcurrentfile}{Logical: At the beginning of each file, message the
name and current time in the console?}

\item{\dots}{Further arguments passed to internal function \code{testExample}
and from there to \code{tools::\link{Rd2ex}}}
}
\value{
Logical indicating successful tests
}
\description{
Test all examples in a package
}
\examples{
# testExamples(selection=1:10)

}
\seealso{
The evaluate package
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Mar 2019
}
\keyword{package}
