% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pal.R
\name{divPal}
\alias{divPal}
\title{Diverging color palette}
\usage{
divPal(n = 100, reverse = FALSE, alpha = 1, rwb = FALSE,
  ryb = FALSE, gp = FALSE, br = FALSE, colors = NULL, ...)
}
\arguments{
\item{n}{Number of colors. DEFAULT: 100}

\item{reverse}{Reverse colors? DEFAULT: FALSE}

\item{alpha}{Transparency (0=transparent, 1=fully colored). DEFAULT: 1}

\item{rwb}{Should colors be in red-white-blue instead of brown-blue? DEFAULT: FALSE}

\item{ryb}{Use red-yellow-blue instead of the default, with "khaki" in the center. DEFAULT: FALSE}

\item{gp}{Use green-purple instead of the default. DEFAULT: FALSE}

\item{br}{Use blue-red instead of the default. DEFAULT: FALSE}

\item{colors}{If not NULL, a color vector used in \code{\link{colorRampPalette}}. DEFAULT: NULL}

\item{\dots}{Further arguments passed to \code{\link{colorRamp}}}
}
\value{
Character string vector with color names
}
\description{
Diverging color palette: brown to blue, light colors in the middle, darker
at the extremes, good for displaying values in two directions
}
\examples{
plot(rep(1,12), pch=16, cex=5, col=divPal(12), xaxt="n")
showPal()
}
\references{
The default palette is originally in 12 shades in the IPCC Assessment Report 5
            Chapter 12 Fig 12.22, \url{http://www.ipcc.ch/report/ar5/wg1/}.\cr
            The green-purple and blue-red palettes are from NYtimes (originally with 8 shades),
            \url{https://nyti.ms/2mL0o4J}
}
\seealso{
\code{\link{showPal}}, \code{\link{seqPal}}, \code{\link{addAlpha}},
         \code{\link{colorRampPalette}}, package \code{RColorBrewer}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jan 2016
}
\keyword{color}
\keyword{dplot}
