% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaPlotComp.R
\name{betaPlotComp}
\alias{betaPlotComp}
\title{Compare beta distributions}
\usage{
betaPlotComp(shape1 = c(0.5, 1:4, 10, 20), shape2 = shape1,
  cumulative = FALSE, cex = 0.8, las = 1, main = "", ylim = lim0(4),
  mar = rep(0, 4), oma = c(2, 2, 4.5, 2), mgp = c(3, 0.7, 0),
  keeppar = FALSE, textargs = NULL, ...)
}
\arguments{
\item{shape1}{Vector of alpha values as in \code{\link{dbeta}}. DEFAULT: c(0.5, 1:4, 10,20)}

\item{shape2}{Beta values to be compared. DEFAULT: shape1}

\item{cumulative}{Should the cumulative density distribution line be added? DEFAULT: FALSE}

\item{cex}{Character EXpansion size. DEFAULT: 0.8}

\item{las}{Label Axis Style passed to \code{\link{axis}}. DEFAULT: 1}

\item{main}{Main as in \code{\link{plot}}. DEFAULT: ""}

\item{ylim}{LIMit for the Y axis. DEFAULT: lim0(4)}

\item{mar}{MARgins for plot passed to \code{\link{par}}. DEFAULT: rep(0,4)}

\item{oma}{Outer MArgins for plot passed to \code{\link{par}}. DEFAULT: c(2,2,4.5,2)}

\item{mgp}{MarGin Placement. DEFAULT: c(3,0.7,0)}

\item{keeppar}{Should margin parameters be kept instead of being restored to previous value? DEFAULT: FALSE}

\item{textargs}{List of arguments passed to \code{\link{textField}}. DEFAULT: NULL}

\item{\dots}{Further arguments passed to \code{\link{betaPlot}} like lines, fill, etc.}
}
\value{
None. Used for plotting.
}
\description{
Visually understand the effect of the beta distribution parameters
}
\note{
Tries to find suitable subplot for axis labels. This works only for increasing parameter values.
}
\examples{

betaPlotComp()
betaPlotComp(oma=c(2,2,2,2), ylim=lim0(5.5), textargs=list(y=NA))
betaPlotComp(shape1=c(3,10,34), shape2=c(7,9,24))

}
\seealso{
\code{\link{betaPlot}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Dec 2015
}
\keyword{distribution}
\keyword{hplot}
