% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonality.R
\name{seasonality}
\alias{seasonality}
\title{Seasonality analysis}
\usage{
seasonality(dates, values, data, drange = NULL, vrange = NULL, shift = 0,
  janline = TRUE, months = substr(month.abb, 1, 1), xlab = "Year",
  ylab = "Month", zlab = substitute(values), ylim = c(370, -3),
  yaxs = "i", main = "Seasonality", mar = c(3, 3, 4, 1), mgp = c(1.9,
  0.7, 0), keeppar = TRUE, ...)
}
\arguments{
\item{dates}{Dates in ascending order. 
Can be charater strings or \code{\link{strptime}} results, 
as accepted (and coerced) by \code{\link{as.Date}}}

\item{values}{Values to be mapped in color with \code{\link{colPoints}}}

\item{data}{Optional: data.frame with the column names as given by dates and values}

\item{drange}{Optional date range (analogous to xlim), 
can be a vector like \code{dates}. DEFAULT: NULL}

\item{vrange}{Optional value range (analogous to ylim), 
can be a vector like \code{values}. DEFAULT: NULL}

\item{shift}{Number of days to move the year-break to. 
E.g. shift=61 for German hydrological year (Nov to Oct). DEFAULT: 0}

\item{janline}{Logical: Should horizontal line be plotted at 
               January 1st if \code{shift!=0}? DEFAULT: TRUE
### @param nmax Number of annual maxima to be marked and returned. DEFAULT: 0}

\item{months}{Labels for the months. DEFAULT: J,F,M,A,M,J,J,A,S,O,N,D}

\item{xlab, ylab}{Labels for the axes. DEFAULT: Year, Month}

\item{zlab}{Title of \code{\link{colPointsLegend}}. DEFAULT: \code{values} name}

\item{ylim, yaxs}{Parameters specifying y Axis appearance, see \code{\link{par}}. 
DEFAULT: c(366,1), "i"}

\item{main}{Graph title, offset to the left. DEFAULT: Seasonality}

\item{mar, mgp}{Parameters specifying plot margin size and labels placement.
DEFAULT: c(3,3,4,1), c(2.2,0.7,0)}

\item{keeppar}{Logical: Keep the margin parameters? If FALSE, they are reset
to the previous values. DEFAULT: TRUE}

\item{\dots}{Further arguments passed to \code{\link{colPoints}} like 
pch, main, xaxs, but not Range (use \code{vrange})}
}
\value{
Data.frame with DOYs of annual maxima and number of nonNA values included
        Please Note that the column year does not note the calendrical year 
        if \code{shift!=0}.
}
\description{
Plot time series to examine it for seasonality
}
\examples{
browseURL("http://nrfa.ceh.ac.uk/data/station/meanflow/39072")
qfile <- system.file("extdata/discharge39072.csv", package="berryFunctions")
Q <- read.table(qfile, skip=19, header=TRUE, sep=",", fill=TRUE)[,1:2]
rm(qfile)
colnames(Q) <- c("date","discharge")
Q$date <- as.Date(Q$date)
Q$discharge[530:540] <- NA
plot(Q, type="l")
spiralDate(date, discharge, data=Q) # most floods in winter
seasonality(date, discharge, data=Q, shift=100, main="NRFA: Thames\\nRoyal Windsor Park")

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jul 2016
}
\seealso{
\code{\link{spiralDate}}
}
\keyword{aplot}

