% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post.R
\name{calc_post_beta}
\alias{calc_post_beta}
\title{Calculate Posterior Beta}
\usage{
calc_post_beta(internal_data, response, prior)
}
\arguments{
\item{internal_data}{This can either be a propensity score object or a tibble
of the internal data.}

\item{response}{Name of response variable}

\item{prior}{A distributional object corresponding to a beta distribution
or a mixture distribution of beta components}
}
\value{
distributional object
}
\description{
Calculate a posterior distribution that is beta (or a mixture
of beta components). Only the relevant treatment arms from the internal
dataset should be read in (e.g., only the control arm if constructing a
posterior distribution for the control response rate).
}
\details{
For a given arm of an internal trial (e.g., the control arm or an
active treatment arm) of size \eqn{N_I}, suppose the response data are binary
such that \eqn{y_i \sim \mbox{Bernoulli}(\theta)}, \eqn{i=1,\ldots,N_I}. The
posterior distribution for \eqn{\theta} is written as

\deqn{\pi( \theta \mid \boldsymbol{y} ) \propto \mathcal{L}(\theta \mid \boldsymbol{y}) \; \pi(\theta),}

where \eqn{\mathcal{L}(\theta \mid \boldsymbol{y})} is the likelihood of the
response data from the internal arm and \eqn{\pi(\theta)} is a prior
distribution on \eqn{\theta} (either a beta distribution or a mixture
distribution with an arbitrary number of beta components). The posterior
distribution for \eqn{\theta} is either a beta distribution or a mixture of
beta components depending on whether the prior is a single beta
distribution or a mixture distribution.
}
\examples{
library(dplyr)
library(distributional)
calc_post_beta(internal_data = filter(int_binary_df, trt == 1),
                              response = y,
                              prior = dist_beta(0.5, 0.5))
}
