% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_conc.R
\name{fit_standard_curve}
\alias{fit_standard_curve}
\title{Fit a standard curve}
\usage{
fit_standard_curve(.data, .parameter = "FL2.H",
  .concentration = "Concentration", .fct = "LL.5", ...)
}
\arguments{
\item{.data}{A tidy data.frame.}

\item{.parameter}{A character giving the name of column(s) where populations
are identified.}

\item{.concentration}{A character giving the name of the column with the
standard concentration.}

\item{.fct}{A character giving the name of the logistic function to use in
the fit, see \code{\link[drc:drm]{drc::drm()}} for details.}

\item{...}{Other arguments to \code{\link[drc:drm]{drc::drm()}}}
}
\value{
An object of class \code{drc}
}
\description{
Fit a logistic function to the standard concentrations.
}
\examples{

library(beadplexr)
library(drc)
data(ryegrass)

ryegrass_m <-
  fit_standard_curve(.data = ryegrass,
                     .parameter = "rootl",
                     .concentration = "conc")

summary(ryegrass_m)

}
