% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BDAloader.R
\name{BDA.loader}
\alias{BDA.loader}
\title{Beta Drift Anaylsis Data Loader}
\usage{
BDA.loader(symbol, frequency = "monthly", xbench = NA, type = "log", ...)
}
\arguments{
\item{symbol}{stock ticker on Yahoo Finance, 
enter as character.}

\item{frequency}{the frequency used to calculate returns 
(\code{"daily"}, \code{"monthly"}, or \code{"yearly"})}

\item{xbench}{ticker symbol of an external benchmark, 
\code{NA} by default.}

\item{type}{type of returns to be calculated (\code{"log"} 
or \code{"arithmetic"}). By default, log returns are used.}

\item{...}{aditional commands passed to the \code{getSymbols} 
function.}
}
\value{
a xts-matrix containing the returns of the security, 
Kenneth French's asset pricing factors and the external 
benchmark (optional).
}
\description{
\code{BDA.loader} prepares a data frame to be used 
by the \code{BDA} function.
}
\details{
\code{BDA.loader} pulls stock price data from Yahoo Finance, 
calculates returns on these prices, downloads factor data from 
Kenneth French's library (via Quandl.com) and bundles all 
data in a xts-matrix that can be passed on to the \code{BDA} 
function.
}
\examples{
testframe <- BDA.loader(symbol = "XOM")
}
\author{
Markus Peter Auer <mp.auer@meanerreversion.com>
}

