% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InterjectionPipe.R
\docType{class}
\name{InterjectionPipe}
\alias{InterjectionPipe}
\title{Class to find and/or remove the interjections on the data field of an Instance}
\usage{
InterjectionPipe
}
\description{
\code{\link{InterjectionPipe}} class is responsible for detecting
the existing interjections in the \strong{data} field of each \code{\link{Instance}}.
Identified interjections are stored inside the \strong{interjection} field of
\code{\link{Instance}} class. Moreover if needed, is able to perform inline
interjections removement.
}
\section{Constructor}{

\preformatted{
InterjectionPipe$new(propertyName = "interjection",
                     propertyLanguageName = "language",
                     alwaysBeforeDeps = list("GuessLanguagePipe"),
                     notAfterDeps = list(),
                     removeInterjections = TRUE)
}
\itemize{
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{propertyName:}}{
(\emph{character}) name of the property associated with the Pipe.
}
\item{\strong{propertyLanguageName:}}{
(\emph{character}) name of the language property.
}
\item{\strong{alwaysBeforeDeps:}}{
(\emph{list}) the dependences alwaysBefore (Pipes that must be executed before this
one).
}
\item{\strong{notAfterDeps:}}{
(\emph{list}) the dependences notAfter (Pipes that cannot be executed after this one).
}
\item{\strong{removeInterjections:}}{
(\emph{logical}) indicates if the interjections are removed or not.
}
}
}
}
}

\section{Details}{

\code{\link{InterjectionPipe}} class requires the resource files (in json format)
containing the list of interjections. To this end, the language of the text
indicated in the \emph{propertyLanguageName} should be contained in the
resource file name (ie. interj.xxx.json where xxx is the value defined in the
\emph{propertyLanguageName} ). The location of the resources should be
defined in the \strong{"resources.interjections.path"} field of
\emph{\link{bdpar.Options}} variable.
}

\section{Note}{

\code{\link{InterjectionPipe}} will automatically invalidate the
\code{\link{Instance}} whenever the obtained data is empty.
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipe}} and implements the
\code{pipe} abstract function.
}

\section{Methods}{

\itemize{
\item{\bold{pipe}}{
Preprocesses the \code{\link{Instance}} to obtain/remove the interjections.
The interjections found in the Pipe are added to the list of properties of
the \code{\link{Instance}}.
\itemize{
\item{\emph{Usage:}}{

\code{pipe(instance)}
}
\item{\emph{Value:}}{
the \code{\link{Instance}} with the modifications that have occurred in the Pipe.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{instance:}}{
(\emph{Instance}) \code{\link{Instance}} to preproccess.
}
}
}
}
}

\item{\bold{findInterjection:}}{
checks if the interjection is in the data.
\itemize{
\item{\emph{Usage:}}{
\code{findInterjection(data, interjection)}{}
}
\item{\emph{Value:}}{
boolean, depending on whether the interjection is on the data.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{data:}}{
(\emph{character}) text where interjection will be replaced.
}
\item{\strong{interjection:}}{
(\emph{character}) indicate the interjection to find.
}
}
}
}
}

\item{\bold{removeInterjection:}}{
removes the interjection in the data.
\itemize{
\item{\emph{Usage:}}{

\code{removeInterjection(interjection, data)}
}
\item{\emph{Value:}}{
the data with interjection removed.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{interjection:}}{
(\emph{character}) indicates the interjection to remove.
}
\item{\strong{data:}}{
(\emph{character}) text where interjection will be removed.
}
}
}
}
}

\item{\bold{getPropertyLanguageName:}}{
gets of name of property language.
\itemize{
\item{\emph{Usage:}}{
\code{getPropertyLanguageName()}
}
\item{\emph{Value:}}{
value of name of property language.
}
}
}

\item{\bold{getResourcesInterjectionsPath:}}{
gets of path of interjections resources.
\itemize{
\item{\emph{Usage:}}{
\code{getResourcesInterjectionsPath()}
}
\item{\emph{Value:}}{
value of path of interjections resources.
}
}
}

\item{\bold{setResourcesInterjectionsPath:}}{
sets the path of interjections resources.
\itemize{
\item{\emph{Usage:}}{
\code{setResourcesInterjectionsPath(path)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{path:}}{
(\emph{character}) the new value of the path of interjections resources.
}
}
}
}
}
}
}

\section{Private fields}{

\itemize{
\item{\bold{propertyLanguageName:}}{
 (\emph{character}) the name of property about language.
}
\item{\bold{resourcesInterjectionsPath:}}{
 (\emph{character}) the path where are the resources.
}
\item{\bold{removeInterjections:}}{
 (\emph{logical}) indicates if the interjections are removed or not.
}
}
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{bdpar.Options}},
         \code{\link{ContractionPipe}}, \code{\link{File2Pipe}},
         \code{\link{FindEmojiPipe}}, \code{\link{FindEmoticonPipe}},
         \code{\link{FindHashtagPipe}}, \code{\link{FindUrlPipe}},
         \code{\link{FindUserNamePipe}}, \code{\link{GuessDatePipe}},
         \code{\link{GuessLanguagePipe}}, \code{\link{Instance}},
         \code{\link{MeasureLengthPipe}}, \code{\link{GenericPipe}},
         \code{\link{ResourceHandler}}, \code{\link{SlangPipe}},
         \code{\link{StopWordPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TargetAssigningPipe}}, \code{\link{TeeCSVPipe}},
         \code{\link{ToLowerCasePipe}}
}
