% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdc_country_from_coordinates.R
\name{bdc_country_from_coordinates}
\alias{bdc_country_from_coordinates}
\title{Get country names from coordinates}
\usage{
bdc_country_from_coordinates(
  data,
  lat = "decimalLatitude",
  lon = "decimalLongitude",
  country = "country"
)
}
\arguments{
\item{data}{data.frame. Containing geographical coordinates and country
names.}

\item{lat}{character string. The column name with latitude in decimal
degrees
and WGS84. Default = "decimalLatitude".}

\item{lon}{character string. The column with longitude in decimal degrees and
WGS84. Default = "decimalLongitude".}

\item{country}{character string. The column name with the country assignment
of each record. Default = "country". If no column name is provided a new
column "country" is created.}
}
\value{
A tibble containing country names for records missing such
information.
}
\description{
Country names derived from valid geographic coordinates are added to records
missing country names.
}
\details{
This function assigns a country name for records missing such
information. Country names are extracted from valid geographic coordinates
using a high-quality map of the world (rnaturalearth package). No
country name is added to records whose coordinates are in the sea.
}
\examples{
\dontrun{
x <- data.frame(
  decimalLatitude = c(-22.9834, -39.857030, -17.06811, -46.69778),
  decimalLongitude = c(-69.095, -68.443588, 37.438108, -13.82444),
  country = c("", NA, NA, "Brazil"))

bdc_country_from_coordinates(
  data = x,
  lat = "decimalLatitude",
  lon = "decimalLongitude",
  country = "country"
)
}
}
