% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdc_create_report.R
\name{bdc_create_report}
\alias{bdc_create_report}
\title{Create a report summarizing the results of data quality tests}
\usage{
bdc_create_report(
  data,
  database_id = "database_id",
  workflow_step,
  save_report = FALSE
)
}
\arguments{
\item{data}{data.frame. Containing a unique identifier for each record and
the results of data quality tests.}

\item{database_id}{character string. The column name with a unique record
identifier.Default = "database_id".}

\item{workflow_step}{character string containing the following
options("prefilter", "taxonomy", "space" or "time").}

\item{save_report}{logical. Should the report be saved for further
inspection? Default = FALSE.}
}
\value{
A data.frame containing a report summarizing the results of data
quality assessment.
}
\description{
Create a report summarizing the results of data quality tests
}
\examples{
\dontrun{
database_id <- c("test_1", "test_2", "test_3", "test_4", "test_5")
.missing_names <- c(TRUE, TRUE, TRUE, FALSE, FALSE)
.missing_coordinates <- c(TRUE, FALSE, FALSE, TRUE, FALSE)
.basisOfRecords_notStandard <- c(TRUE, TRUE, FALSE, TRUE, TRUE)
.summary <- c(TRUE, FALSE, FALSE, FALSE, FALSE)

x <- data.frame(
  database_id,
  .missing_names,
  .missing_coordinates,
  .basisOfRecords_notStandard,
  .summary
)

report <- 
bdc_create_report(
  data = x,
  database_id = "database_id",
  workflow_step = "prefilter",
  save_report = FALSE
)
}

}
