% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcp-data.R
\docType{data}
\name{lombard}
\alias{lombard}
\title{Milling machine indentation data}
\format{A vector of length 100 containing the individual radii.}
\source{
The data is available online in the data archive of the
\emph{Journal of Applied Econometrics}. url: 
 \url{http://qed.econ.queensu.ca/jae/2003-v18.1/bai-perron/}.
}
\usage{
lombard
}
\description{
Radii of 100 circular indentations cut by a milling machine.
}
\examples{
 
\dontrun{
data(lombard)
# univariate change point analysis
bcp.model <- bcp(lombard, burnin=500, mcmc=5000, return.mcmc=TRUE)

# linear model change point analysis 
bcpr.model <- bcp(lombard, cbind(1:100), burnin=500, mcmc=5000, return.mcmc=TRUE)

plot(bcp.model, main="Lombard Milling Data")
plot(bcpr.model, main="Lombard Milling Data (with Regression Model)")
}
}
\references{
\enumerate{ 
\item Daniel Barry and J. A. Hartigan (1993), A Bayesian Analysis for Change Point Problems, \emph{Journal of The American Statistical Association}, \bold{88}, 309-19.
\item F. Lombard (1987), Rank Tests for Changepoint Problems, \emph{Biometrika}, \bold{74}, 615-624. 
}
}
\keyword{datasets}
