#' Calculate Watanabe–Akaike information criterion
#'
#' \code{waic} returns the Watanabe–Akaike information criterion (WAIC) for the
#'   supplied model. WAIC is a generalization of the Akaike information
#'   criterion onto singular statistical model.
#'
#'   NOTE: in order to calculated WAIC, the model MUST track the parameter
#'   "lambda". In species that are data-rich, such as Wood Thrush,
#'   this produces extremely large JAGS objects, and takes up a considerable
#'   amount of memory when simulating with \code{run_model}
#'
#'   See examples for details.
#'
#' @param jags_data Data prepared by \code{prepare_jags_data}, used
#'   for input to the JAGS model
#' @param jags_mod JAGS list generated by \code{run_model}
#'
#' @return Double precision numerical value
#'
#' @name bbsBayes-deprecated
#' @seealso \code{\link{waic}}
#' @keywords internal
NULL

#' @rdname bbsBayes-deprecated
#' @section \code{waic}:
#'   WAIC should no longer be used for BBS data.
#'   Cross validation should be used instead.
#'
#' @export
#'

waic <- function(jags_data = NULL,
                 jags_mod = NULL)
{
  .Deprecated(msg = "WAIC should no longer be used for BBS data. Use cross validation instead.")

  lppd_sum <- lppd(jags_data = jags_data, jags_mod = jags_mod)
  pwaic_sum <- p_waic(jags_data = jags_data, jags_mod = jags_mod)

  return(-2 * (lppd_sum - pwaic_sum))
}
