% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayesian_Bricks.r
\name{pdsInverse}
\alias{pdsInverse}
\title{Inverse of a positive definite symmetric matrix}
\usage{
pdsInverse(S, returnUpper = FALSE)
}
\arguments{
\item{S}{a symmetric positive definitive matrix.}

\item{returnUpper}{logical, return inv(A) if returnUpper=TRUE,return inv(S) if returnUpper=FALSE, default FALSE.}
}
\value{
A matrix, the inverse of "S".
}
\description{
Use Cholesky decomposition to calculate the inverse of S,  where \eqn{S = A'A}, A is a upper diagonal matrix. inv(S) = inv(A)inv(A)'.
}
\examples{
Sigma = matrix(c(2,1,1,2),2,2)      # some positive definite symmetric matrix
pdsInverse(Sigma)                   # get inv(Sigma)
pdsInverse(Sigma,returnUpper=TRUE)  # get inv(A), where Sigma=A'A, A is upper triangle
}
