% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{MAP.GaussianInvWishart}
\alias{MAP.GaussianInvWishart}
\title{Maximum A Posteriori (MAP) estimate of a "GaussianInvWishart" object}
\usage{
\method{MAP}{GaussianInvWishart}(obj, ...)
}
\arguments{
\item{obj}{A "GaussianInvWishart" object.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
matrix, the MAP estimate of "Sigma".
}
\description{
Generate the MAP estimate of Sigma in following model structure:
    \deqn{x \sim Gaussian(mu,Sigma)}
    \deqn{Sigma \sim InvWishart(v,S)}
mu is known. Gaussian() is the Gaussian distribution. See \code{?dGaussian} and \code{?dInvWishart} for the definition of the distributions.\cr
The model structure and prior parameters are stored in a "GaussianInvWishart" object. \cr
The MAP estimates are:
\itemize{
  \item (Sigma_MAP) = argmax p(Sigma|v,S,x,mu)
}
}
\examples{
obj <- GaussianInvWishart(gamma=list(mu=c(-1.5,1.5),v=3,S=diag(2)))
x <- rGaussian(100,mu = c(-1.5,1.5),Sigma = matrix(c(0.1,0.03,0.03,0.1),2,2))
ss <- sufficientStatistics(obj=obj,x=x,foreach = FALSE)
posterior(obj=obj,ss = ss)
MAP(obj)
}
\references{
Gelman, Andrew, et al. Bayesian data analysis. CRC press, 2013.

MARolA, K. V., JT KBNT, and J. M. Bibly. Multivariate analysis. AcadeInic Press, Londres, 1979.
}
\seealso{
\code{\link{GaussianInvWishart}}
}
