% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayesian_Bricks.r
\name{sufficientStatistics}
\alias{sufficientStatistics}
\title{Get sample sufficient statistics}
\usage{
sufficientStatistics(obj, ...)
}
\arguments{
\item{obj}{A "BayesianBrick" object used to select a method.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An object of corresponding sufficient statistics class, such as "ssGaussian"
}
\description{
This is a generic function that will generate the sufficient statistics of a given Bayesian bricks object. i.e.
for the model structure: \cr
     theta|gamma ~ H(gamma) \cr
     X|theta ~ F(theta) \cr
get the sufficient statistics T(X)
}
\examples{
x <- rGaussian(10,mu = 1,Sigma = 1)
obj <- GaussianNIW()                    #an GaussianNIW object
sufficientStatistics(obj=obj,x=x)
}
\seealso{
\code{\link{sufficientStatistics.GaussianNIW}} for Gaussian-NIW conjugate structure, \code{\link{sufficientStatistics.GaussianNIG}} for Gaussian-NIG conjugate structure, \code{\link{sufficientStatistics.CatDirichlet}} for Categorical-Dirichlet conjugate structure, \code{\link{sufficientStatistics.CatDP}} for Categorical-DP conjugate structure ...
}
