% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Categorical_Inference.r
\name{sufficientStatistics.CatDirichlet}
\alias{sufficientStatistics.CatDirichlet}
\title{Sufficient statistics of a "CatDirichlet" object}
\usage{
\method{sufficientStatistics}{CatDirichlet}(obj, x, foreach = FALSE, ...)
}
\arguments{
\item{obj}{A "CatDirichlet" object.}

\item{x}{numeric,integer or character, samples of the Categorical distribution.}

\item{foreach}{logical, specifying whether to return the sufficient staistics for each observation. Default FALSE.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
An object of class "ssCat", the sufficient statistics of a set of categorical samples. Or an object of the same class as x if foreach=TRUE.
}
\description{
For following Categorical-Dirichlet model structure: \cr
     pi|alpha ~ Dir(alpha) \cr
     x|pi ~ Categorical(pi) \cr
the sufficient statistics of a set of samples x is the effective counts of each uniqueLabel in x. i.e. T(x)[i] = sum(uniqueLabels[i]%in%x). \cr
Unique values of x must be in obj$gamma$uniqueLabels, where "obj" is a "CatDirichlet" object, see examples below.
}
\examples{
obj <- CatDirichlet(gamma=list(alpha=runif(26,1,2),uniqueLabels = letters))
x <- sample(letters,size = 20,replace = TRUE)
w <- runif(20)
sufficientStatistics(obj=obj,x=x)       #return the counts of each unique label
sufficientStatistics_Weighted(obj=obj,x=x,w=w) #return the weighted counts of each unique lable
sufficientStatistics(obj=obj,x=x,foreach = TRUE) #return the sample itself
}
\references{
Murphy, Kevin P. Machine learning: a probabilistic perspective. MIT press, 2012.
}
\seealso{
\code{\link{CatDirichlet}}, \code{\link{sufficientStatistics_Weighted.CatDirichlet}}
}
