% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{rPosteriorPredictive.DP}
\alias{rPosteriorPredictive.DP}
\title{Posterior predictive random generation of a "DP" object}
\usage{
\method{rPosteriorPredictive}{DP}(obj, n = 1, x, ...)
}
\arguments{
\item{obj}{A "DP" object.}

\item{n}{integer, number of samples.}

\item{x}{Random samples of the "BasicBayesian" object.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
integer, the categorical samples.
}
\description{
Generate random samples from the posterior predictive distribution of the following structure: \cr
     pi|alpha ~ DP(alpha,U) \cr
     z|pi ~ Categorical(pi) \cr
     theta_z|psi ~ H0(psi) \cr
     x|theta_z,z ~ F(theta_z) \cr
where DP(alpha,U) is a Dirichlet Process on positive integers, alpha is the "concentration parameter" of the Dirichlet Process, U is the "base measure" of this Dirichlet process. The choice of F() and H0() can be arbitrary, they are distributions of x and theta_z correspondingly. \cr
The model structure and prior parameters are stored in a "DP" object. \cr
This function will generate random samples from the distribution  z|alpha,psi,x.
}
\examples{
x <- rnorm(4)
z <- sample(1L:10L,size = 4,replace = TRUE)
obj <- DP()
ss <- sufficientStatistics(obj = obj,x=x,foreach = TRUE)
for(i in 1L:length(x)) posterior(obj = obj,ss=ss[[i]],z=z[i])
xnew <- rnorm(10)
znew <- sample(1L:10L,size = 10,replace = TRUE)
rPosteriorPredictive(obj = obj,n=1,x=xnew[5])
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
@seealso \code{\link{DP}}, \code{\link{dPosteriorPredictive.DP}}
}
