% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppd-test-statistics.R
\name{PPD-test-statistics}
\alias{PPD-test-statistics}
\alias{PPD-statistics}
\alias{ppd_stat}
\alias{ppd_stat_grouped}
\alias{ppd_stat_freqpoly}
\alias{ppd_stat_freqpoly_grouped}
\alias{ppd_stat_2d}
\alias{ppd_stat_data}
\title{PPD test statistics}
\usage{
ppd_stat(
  ypred,
  stat = "mean",
  ...,
  binwidth = NULL,
  breaks = NULL,
  freq = TRUE
)

ppd_stat_grouped(
  ypred,
  group,
  stat = "mean",
  ...,
  facet_args = list(),
  binwidth = NULL,
  breaks = NULL,
  freq = TRUE
)

ppd_stat_freqpoly(
  ypred,
  stat = "mean",
  ...,
  facet_args = list(),
  binwidth = NULL,
  freq = TRUE
)

ppd_stat_freqpoly_grouped(
  ypred,
  group,
  stat = "mean",
  ...,
  facet_args = list(),
  binwidth = NULL,
  freq = TRUE
)

ppd_stat_2d(ypred, stat = c("mean", "sd"), ..., size = 2.5, alpha = 0.7)

ppd_stat_data(ypred, group = NULL, stat)
}
\arguments{
\item{ypred}{An \code{S} by \code{N} matrix of draws from the posterior (or prior)
predictive distribution. The number of rows, \code{S}, is the size of the
posterior (or prior) sample used to generate \code{ypred}. The number of
columns, \code{N}, is the number of predicted observations.}

\item{stat}{A single function or a string naming a function, except for the
2D plot which requires a vector of exactly two names or functions. In all
cases the function(s) should take a vector input and return a scalar
statistic. If specified as a string (or strings) then the legend will
display the function name(s). If specified as a function (or functions)
then generic naming is used in the legend.}

\item{...}{Currently unused.}

\item{binwidth}{Passed to \code{\link[ggplot2:geom_histogram]{ggplot2::geom_histogram()}} to override
the default binwidth.}

\item{breaks}{Passed to \code{\link[ggplot2:geom_histogram]{ggplot2::geom_histogram()}} as an
alternative to \code{binwidth}.}

\item{freq}{For histograms, \code{freq=TRUE} (the default) puts count on the
y-axis. Setting \code{freq=FALSE} puts density on the y-axis. (For many
plots the y-axis text is off by default. To view the count or density
labels on the y-axis see the \code{\link[=yaxis_text]{yaxis_text()}} convenience
function.)}

\item{group}{A grouping variable of the same length as \code{y}.
Will be coerced to \link[base:factor]{factor} if not already a factor.
Each value in \code{group} is interpreted as the group level pertaining
to the corresponding observation.}

\item{facet_args}{A named list of arguments (other than \code{facets}) passed
to \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}} or \code{\link[ggplot2:facet_grid]{ggplot2::facet_grid()}}
to control faceting. Note: if \code{scales} is not included in \code{facet_args}
then \strong{bayesplot} may use \code{scales="free"} as the default (depending
on the plot) instead of the \strong{ggplot2} default of \code{scales="fixed"}.}

\item{size}{For the 2D plot only, arguments passed to
\code{\link[ggplot2:geom_point]{ggplot2::geom_point()}} to control the appearance of scatterplot points.}

\item{alpha}{For the 2D plot only, arguments passed to
\code{\link[ggplot2:geom_point]{ggplot2::geom_point()}} to control the appearance of scatterplot points.}
}
\value{
The plotting functions return a ggplot object that can be further
customized using the \strong{ggplot2} package. The functions with suffix
\verb{_data()} return the data that would have been drawn by the plotting
function.
}
\description{
The distribution of a (test) statistic \code{T(ypred)}, or a pair of (test)
statistics, over the simulations from the posterior or prior predictive
distribution. Each of these functions makes the same plot as the
corresponding \code{\link[=PPC-test-statistics]{ppc_}} function but without comparing to
any observed data \code{y}. The \strong{Plot Descriptions} section at
\link{PPC-test-statistics} has details on the individual plots.
}
\details{
For Binomial data, the plots may be more useful if
the input contains the "success" \emph{proportions} (not discrete
"success" or "failure" counts).
}
\examples{
yrep <- example_yrep_draws()
ppd_stat(yrep)
ppd_stat(yrep, stat = "sd") + legend_none()

# use your own function for the 'stat' argument
color_scheme_set("brightblue")
q25 <- function(y) quantile(y, 0.25)
ppd_stat(yrep, stat = "q25") # legend includes function name
}
\references{
Gabry, J. , Simpson, D. , Vehtari, A. , Betancourt, M. and
Gelman, A. (2019), Visualization in Bayesian workflow.
\emph{J. R. Stat. Soc. A}, 182: 389-402. doi:10.1111/rssa.12378.
(\href{https://rss.onlinelibrary.wiley.com/doi/full/10.1111/rssa.12378}{journal version},
\href{https://arxiv.org/abs/1709.01449}{arXiv preprint},
\href{https://github.com/jgabry/bayes-vis-paper}{code on GitHub})
}
\seealso{
Other PPDs: 
\code{\link{PPD-distributions}},
\code{\link{PPD-intervals}},
\code{\link{PPD-overview}}
}
\concept{PPDs}
