% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesplot-ggplot-themes.R
\name{theme_default}
\alias{theme_default}
\title{Default bayesplot plotting theme}
\usage{
theme_default(base_size = getOption("bayesplot.base_size", 12),
  base_family = getOption("bayesplot.base_family", "serif"))
}
\arguments{
\item{base_size, base_family}{Base font size and family (passed to
\code{\link[ggplot2]{theme_bw}}). It is possible to set
\code{"bayesplot.base_size"} and \code{"bayesplot.base_family"} via
\code{\link{options}} to change the defaults, which are \code{12} and
\code{"serif"}, respectively.}
}
\value{
A ggplot \link[ggplot2]{theme} object.
}
\description{
The \code{\link{theme_default}} function returns the default ggplot
\link{theme} used by the \pkg{bayesplot} plotting functions.
After loading the \pkg{bayesplot} package, this theme will be the default for
\emph{all} graphs made with \pkg{ggplot2}. See the \strong{Details} section,
below.
}
\details{
After loading \pkg{bayesplot}, if you subsequently change the
default \pkg{ggplot2} theme (i.e., by calling
\code{\link[ggplot2]{theme_set}} or loading a different package that changes
the theme) then \pkg{bayesplot} will use that theme instead. To change back
to the default \pkg{bayesplot} theme use \code{bayesplot::theme_default()} as
the argument to \code{\link[ggplot2]{theme_set}}.
}
\examples{
class(theme_default())

# plot using the default theme
ggplot2::theme_set(theme_default())
x <- example_mcmc_draws()
mcmc_hist(x)

# change the default font size and family
ggplot2::theme_set(theme_default(base_size = 8, base_family = "sans"))
mcmc_hist(x)
mcmc_areas(x, regex_pars = "beta")

# change back
ggplot2::theme_set(theme_default())
mcmc_areas(x, regex_pars = "beta")

# use one of the themes included in ggplot2
ggplot2::theme_set(ggplot2::theme_gray())
mcmc_dens_overlay(x)

# change back to bayesplot default theme
ggplot2::theme_set(bayesplot::theme_default())
mcmc_dens_overlay(x)

}
\seealso{
\link{bayesplot-helpers} for a variety of convenience functions,
  many of which provide shortcuts for tweaking theme elements after creating
  a plot.

\code{\link{bayesplot-colors}} to set or view the color scheme used
  for plotting.
}
