% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc-overview.R
\name{MCMC-overview}
\alias{MCMC}
\alias{MCMC-overview}
\title{Plots for Markov chain Monte Carlo simulations}
\description{
The \pkg{bayesplot} MCMC module provides various plotting functions for
creating graphical displays of Markov chain Monte Carlo (MCMC) simulations.
The \strong{MCMC plotting functions} section, below, provides links to the
documentation for various categories of MCMC plots. Currently the MCMC
plotting functions accept posterior draws provided in one of the following
formats:
\itemize{
 \item \strong{3-D array}: An \code{\link{array}} with dimensions
 \code{[Iteration, Chain, Parameter]} in that order.
 \item \strong{list}: A \code{list} of matrices, where each matrix
 corresponds to a Markov chain. All of the matrices should have the same
 number of iterations (rows) and parameters (columns), and parameters should
 have the same names and be in the same order.
 \item \strong{matrix}: A \code{\link{matrix}} with one column per parameter.
 If using matrix there should only be a single Markov chain or all chains
 should already be merged (stacked).
 \item \strong{data frame}: There are two types of \link[=data.frame]{data
 frames} allowed. Either a data frame with one column per parameter (if only
 a single chain or all chains have already been merged), or a data frame with
 one column per parameter plus an additional column \code{"Chain"} that
 contains the chain number (an integer) corresponding to each row in
 the data frame.
}
}
\section{MCMC plotting functions}{


\describe{
  \item{\strong{\link[=MCMC-distributions]{Posterior distributions}}}{
    Histograms and kernel density plots of parameter draws, optionally
    showing each Markov chain separately.
  }
  \item{\strong{\link[=MCMC-intervals]{Uncertainty intervals}}}{
    Uncertainty intervals computed from parameter draws.
  }
  \item{\strong{\link[=MCMC-traces]{Traceplots}}}{
    Times series of parameter draws.
  }
  \item{\strong{\link[=MCMC-scatterplots]{Scatterplots}}}{
    Various scatterplots of parameter draws.
  }
  \item{\strong{\link[=MCMC-combos]{Combinations}}}{
    Combination plots (e.g. traceplot + histogram).
  }
  \item{\strong{\link[=MCMC-nuts]{NUTS diagnostics}}}{
    Diagnostic plots for the No-U-Turn Sampler.
  }
}
}
\seealso{
Other MCMC: \code{\link{MCMC-combos}},
  \code{\link{MCMC-diagnostics}},
  \code{\link{MCMC-distributions}},
  \code{\link{MCMC-intervals}}, \code{\link{MCMC-nuts}},
  \code{\link{MCMC-scatterplots}},
  \code{\link{MCMC-traces}}
}

