% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispersion.R
\name{dispersion}
\alias{dispersion}
\title{Posterior dispersion}
\usage{
dispersion(model, summary = FALSE)
}
\arguments{
\item{model}{An object of class \code{\link[brms]{brmsfit}} whose
distribution family is either \code{\link[stats]{gaussian}},
\code{\link[stats]{poisson}} or \code{\link[stats]{binomial}}.}

\item{summary}{Logical. Should summary stats be returned instead of full
vector? Defaults to FALSE.}
}
\value{
If \code{summary} is FALSE, an n-long \code{\link[base]{numeric}}
vector containing the dispersion metric, where n is the number of post
warm-up posterior draws from the \code{\link[brms]{brmsfit}} object. If
TRUE, then a \code{\link[base]{data.frame}} containing the summary stats
(mean, median, 95\% highest density intervals). of the dispersion metric.
}
\description{
Calculates posterior dispersion metric
}
\details{
This function calculates a dispersion metric which takes the ratio
between the observed relative to simulated Pearson residuals sums of
squares.
}
\examples{
library(bayesnec)
data(manec_example)
exmp_brmsfit <- manec_example$mod_fits$nec4param$fit
dispersion(exmp_brmsfit, summary = TRUE)

}
