% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation_helper_functions.R
\name{assign_tseg}
\alias{assign_tseg}
\title{Add segment numbers to observations}
\usage{
assign_tseg(dat, brkpts)
}
\arguments{
\item{dat}{A list where each element stores the data for a unique animal ID.
Each element is a data frame that contains all data associated for a given
animal ID and must include a column labeled \code{time1} that numbers each
of the observations in consecutive order. This variable is automatically
generated by the \code{\link{filter_time}} function during data
preparation.}

\item{brkpts}{A data frame of breakpoints for each animal ID (as generated by
\code{\link{get_breakpts}}).}
}
\value{
A data frame that updates the original data object by including the
  segment number associated with each observation in relation to the
  extracted breakpoints.
}
\description{
After breakpoints have been extracted for each animal ID, this function
assigns the associated segment number to observations for each animal ID.
These segments of observations will be used in the second stage of the model
framework to perform mixed-membership clustering by Latent Dirichlet
Allocation.
}
\examples{
\donttest{
#load data
data(tracks.list)

#subset only first track
tracks.list<- tracks.list[1]

#only retain id and discretized step length (SL) and turning angle (TA) columns
tracks.list2<- purrr::map(tracks.list,
                   subset,
                  select = c(id, SL, TA))


set.seed(1)

# Define model params
alpha<- 1
ngibbs<- 1000
nbins<- c(5,8)

#future::plan(future::multisession)  #run all MCMC chains in parallel
dat.res<- segment_behavior(data = tracks.list2, ngibbs = ngibbs, nbins = nbins,
                           alpha = alpha)


# Determine MAP iteration for selecting breakpoints and store breakpoints
MAP.est<- get_MAP(dat = dat.res$LML, nburn = ngibbs/2)
brkpts<- get_breakpts(dat = dat.res$brkpts, MAP.est = MAP.est)


# Assign track segments to all observations by ID
tracks.seg<- assign_tseg(dat = tracks.list, brkpts = brkpts)
}

}
