% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDA_helper_functions.R
\name{expand_behavior}
\alias{expand_behavior}
\title{Expand behavior estimates from track segments to observations}
\usage{
expand_behavior(dat, theta.estim, obs, nbehav, behav.names, behav.order)
}
\arguments{
\item{dat}{A data frame of the animal ID, track segment labels, and all other
data per observation. Animal ID, date, track segment, and observation
number columns must be labeled \emph{id}, \emph{date}, \emph{tseg}, and
\emph{time1}, respectively.}

\item{theta.estim}{A matrix (returned by \code{\link{extract_prop}})
containing the proportions of each behavioral state as separate columns for
each track segment (rows).}

\item{obs}{A data frame summarizing the number of observations within each
bin per movement variable that is returned by
\code{\link{summarize_tsegs}}.}

\item{nbehav}{numeric. The number of behavioral states that will be retained
in 1 to nmaxclust.}

\item{behav.names}{character. A vector of names to label each state (in
order).}

\item{behav.order}{numeric. A vector that identifies the order in which the
user would like to rearrange the behavioral states. If satisfied with order
returned by the LDA model, this still must be specified.}
}
\value{
A new data frame that expands behavior proportions for each
  observation within all track segments, including the columns labeled
  \emph{time1} and \emph{date} from the original \code{dat} data frame.
}
\description{
Expand behavior estimates from track segments to observations
}
\examples{

\donttest{
#load data
data(tracks.seg)

#select only id, tseg, SL, and TA columns
tracks.seg2<- tracks.seg[,c("id","tseg","SL","TA")]

#summarize data by track segment
obs<- summarize_tsegs(dat = tracks.seg2, nbins = c(5,8))

#cluster data with LDA
res<- cluster_segments(dat = obs, gamma1 = 0.1, alpha = 0.1, ngibbs = 1000,
                       nburn = 500, nmaxclust = 7, ndata.types = 2)

#Extract proportions of behaviors per track segment
theta.estim<- extract_prop(res = res, ngibbs = 1000, nburn = 500, nmaxclust = 7)

#Create augmented matrix by replicating rows (tsegs) according to obs per tseg
theta.estim.long<- expand_behavior(dat = tracks.seg, theta.estim = theta.estim, obs = obs,
                               nbehav = 3, behav.names = c("Encamped","ARS","Transit"),
                               behav.order = c(1,2,3))
}


}
