% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip-gen_additive_reg.R
\name{gen_additive_stan_fit_impl}
\alias{gen_additive_stan_fit_impl}
\title{Low-Level ARIMA function for translating modeltime to forecast}
\usage{
gen_additive_stan_fit_impl(
  formula,
  data,
  chains = 4,
  iter = 2000,
  warmup = 1000,
  ...
)
}
\arguments{
\item{formula}{A dataframe of xreg (exogenous regressors)}

\item{data}{A numeric vector of values to fit}

\item{chains}{An integer of the number of Markov Chains chains to be run, by default 4 chains are run.}

\item{iter}{An integer of total iterations per chain including the warm-up, by default the number of iterations are 2000.}

\item{warmup}{A positive integer specifying number of warm-up (aka burn-in) iterations. This also specifies the number of iterations used for step-size adaptation, so warm-up samples should not be used for inference. The number of warmup should not be larger than iter and the default is iter/2.}

\item{...}{Additional arguments passed to \code{forecast::Arima}}
}
\value{
A modeltime model
}
\description{
Low-Level ARIMA function for translating modeltime to forecast
}
