% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{posterior_heatmap}
\alias{posterior_heatmap}
\title{Posterior heatmaps for VAR coefficients or variance-covariance matrices}
\usage{
posterior_heatmap(
  x,
  FUN,
  ...,
  colorbar = TRUE,
  xlabels = NULL,
  ylabels = NULL,
  add_numbers = FALSE,
  zlim = NULL,
  colspace = NULL,
  main = "",
  cex.axis = 0.75,
  cex.colbar = 1,
  cex.numbers = 1,
  asp = NULL
)
}
\arguments{
\item{x}{An array of dimension \eqn{a \times b \times draws}, where \eqn{a
  \times b} is the dimension of the parameter to visualize and draws is the
number of posterior draws.}

\item{FUN}{The summary function to be applied to margins \code{c(1,2)} of x. E.g.
\code{"median"}, \code{"mean"}, \code{"IQR"}, \code{"sd"} or \code{"var"}.
\code{apply(x, 1:2, FUN, ...)} must return a matrix!}

\item{...}{optional arguments to \code{FUN}.}

\item{colorbar}{logical indicating whether to display a colorbar or not.
Default is \code{TRUE}.}

\item{xlabels}{\code{ylabels=NULL}, the default, indicates that the names of
the dependent variables will be displayed. \code{ylabels=""} indicates that
no ylabels will be displayed.}

\item{ylabels}{\code{xlabels=NULL}, the default, indicates that the labels of
all covariables (the lagged values of the dependent variables) will be
displayed. \code{xlabels="lags"} indicates that only the lags will be
marked. \code{xlabels=""} indicates that no ylabels are displayed.}

\item{add_numbers}{logical. \code{add_numbers=TRUE}, the default indicates
that the actual values of \code{summary} will be displayed.}

\item{zlim}{numeric vector of length two indicating the minimum and maximum
values for which colors should be plotted. By default this range is
determined by the maximum of the absolute values of the selected summary.}

\item{colspace}{Optional argument.}

\item{main}{main title for the plot.}

\item{cex.axis}{The magnification to be used for y-axis annotation relative
to the current setting of cex.}

\item{cex.colbar}{The magnification to be used for colorbar annotation
relative to the current setting of cex.}

\item{cex.numbers}{The magnification to be used for the actual values (if
\code{add_numbers=TRUE}) relative to the current setting of cex.}

\item{asp}{aspect ratio.}
}
\value{
Returns \code{x} invisibly.
}
\description{
Posterior heatmaps for VAR coefficients or variance-covariance matrices
}
\examples{
# Access a subset of the usmacro_growth dataset
data <- usmacro_growth[,c("GDPC1", "CPIAUCSL", "FEDFUNDS")]

# Estimate a model
mod <- bvar(100*data, sv_keep = "all", quiet = TRUE)

# Extract posterior draws of VAR coefficients
phi_post <- coef(mod)

# Visualize posterior median of VAR coefficients
posterior_heatmap(phi_post, median)

# Extract posterior draws of variance-covariance matrices (for each point in time)
sigma_post <- vcov(mod)
# Visualize posterior interquartile-range of variance-covariance matrix of the first observation
posterior_heatmap(sigma_post[1,,,], IQR)
}
\seealso{
Other plotting \code{\link[=plot.bayesianVARs_bvar]{plot.bayesianVARs_bvar()}},
\code{\link[=plot.bayesianVARs_fitted]{plot.bayesianVARs_fitted()}}, \code{\link[=plot.bayesianVARs_predict]{plot.bayesianVARs_predict()}},
\code{\link[=pairs.bayesianVARs_predict]{pairs.bayesianVARs_predict()}}.
}
