
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_corr_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_corr");
    reader.add_event(14, 14, "end", "model_corr");
    return reader;
}

class model_corr : public prob_grad {
private:
    int N;
    vector_d y;
    vector_d x;
public:
    model_corr(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_corr(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_corr_namespace::model_corr";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            validate_non_negative_index("y", "N", N);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(N));
            validate_non_negative_index("y", "N", N);
            y = vector_d(static_cast<Eigen::VectorXd::Index>(N));
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_i_vec_lim__ = N;
            for (size_t i_vec__ = 0; i_vec__ < y_i_vec_lim__; ++i_vec__) {
                y[i_vec__] = vals_r__[pos__++];
            }
            validate_non_negative_index("x", "N", N);
            context__.validate_dims("data initialization", "x", "vector_d", context__.to_vec(N));
            validate_non_negative_index("x", "N", N);
            x = vector_d(static_cast<Eigen::VectorXd::Index>(N));
            vals_r__ = context__.vals_r("x");
            pos__ = 0;
            size_t x_i_vec_lim__ = N;
            for (size_t i_vec__ = 0; i_vec__ < x_i_vec_lim__; ++i_vec__) {
                x[i_vec__] = vals_r__[pos__++];
            }

            // validate, data variables
            check_greater_or_equal(function__,"N",N,0);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            ++num_params_r__;
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_corr() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("beta")))
            throw std::runtime_error("variable beta missing");
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta", "double", context__.to_vec());
        double beta(0);
        beta = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(-(1),1,beta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "double", context__.to_vec());
        double sigma(0);
        sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            T__ beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.scalar_lub_constrain(-(1),1,lp__);
            else
                beta = in__.scalar_lub_constrain(-(1),1);

            T__ sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.scalar_lb_constrain(0,lp__);
            else
                sigma = in__.scalar_lb_constrain(0);


            // transformed parameters



            // validate transformed parameters

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            // model body

            lp_accum__.add(student_t_log<propto__>(sigma, 3, 0, 2));
            lp_accum__.add(normal_log<propto__>(y, multiply(beta,x), sigma));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta");
        names__.push_back("sigma");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_corr_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double beta = in__.scalar_lub_constrain(-(1),1);
        double sigma = in__.scalar_lb_constrain(0);
        vars__.push_back(beta);
        vars__.push_back(sigma);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {



            // validate transformed parameters

            // write transformed parameters

            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_corr";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (!include_gqs__) return;
    }

}; // model

}




// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_dfa_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_dfa");
    reader.add_event(253, 253, "end", "model_dfa");
    return reader;
}

class model_dfa : public prob_grad {
private:
    int N;
    int P;
    int K;
    int nZ;
    vector<int> row_indx;
    vector<int> col_indx;
    int nVariances;
    vector<int> varIndx;
    int nZero;
    vector<int> row_indx_z;
    vector<int> col_indx_z;
    int n_pos;
    vector<int> row_indx_pos;
    vector<int> col_indx_pos;
    vector<double> y;
    int n_na;
    vector<int> row_indx_na;
    vector<int> col_indx_na;
    double nu_fixed;
    int num_covar;
    int num_unique_covar;
    matrix_d d_covar;
    vector<vector<int> > covar_indexing;
    int estimate_nu;
    int use_normal;
    int est_cor;
    int est_phi;
    int est_theta;
    int n_pcor;
    int n_loglik;
    vector_d zeros;
public:
    model_dfa(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_dfa(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_dfa_namespace::model_dfa";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            context__.validate_dims("data initialization", "P", "int", context__.to_vec());
            P = int(0);
            vals_i__ = context__.vals_i("P");
            pos__ = 0;
            P = vals_i__[pos__++];
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            context__.validate_dims("data initialization", "nZ", "int", context__.to_vec());
            nZ = int(0);
            vals_i__ = context__.vals_i("nZ");
            pos__ = 0;
            nZ = vals_i__[pos__++];
            validate_non_negative_index("row_indx", "nZ", nZ);
            context__.validate_dims("data initialization", "row_indx", "int", context__.to_vec(nZ));
            validate_non_negative_index("row_indx", "nZ", nZ);
            row_indx = std::vector<int>(nZ,int(0));
            vals_i__ = context__.vals_i("row_indx");
            pos__ = 0;
            size_t row_indx_limit_0__ = nZ;
            for (size_t i_0__ = 0; i_0__ < row_indx_limit_0__; ++i_0__) {
                row_indx[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("col_indx", "nZ", nZ);
            context__.validate_dims("data initialization", "col_indx", "int", context__.to_vec(nZ));
            validate_non_negative_index("col_indx", "nZ", nZ);
            col_indx = std::vector<int>(nZ,int(0));
            vals_i__ = context__.vals_i("col_indx");
            pos__ = 0;
            size_t col_indx_limit_0__ = nZ;
            for (size_t i_0__ = 0; i_0__ < col_indx_limit_0__; ++i_0__) {
                col_indx[i_0__] = vals_i__[pos__++];
            }
            context__.validate_dims("data initialization", "nVariances", "int", context__.to_vec());
            nVariances = int(0);
            vals_i__ = context__.vals_i("nVariances");
            pos__ = 0;
            nVariances = vals_i__[pos__++];
            validate_non_negative_index("varIndx", "P", P);
            context__.validate_dims("data initialization", "varIndx", "int", context__.to_vec(P));
            validate_non_negative_index("varIndx", "P", P);
            varIndx = std::vector<int>(P,int(0));
            vals_i__ = context__.vals_i("varIndx");
            pos__ = 0;
            size_t varIndx_limit_0__ = P;
            for (size_t i_0__ = 0; i_0__ < varIndx_limit_0__; ++i_0__) {
                varIndx[i_0__] = vals_i__[pos__++];
            }
            context__.validate_dims("data initialization", "nZero", "int", context__.to_vec());
            nZero = int(0);
            vals_i__ = context__.vals_i("nZero");
            pos__ = 0;
            nZero = vals_i__[pos__++];
            validate_non_negative_index("row_indx_z", "nZero", nZero);
            context__.validate_dims("data initialization", "row_indx_z", "int", context__.to_vec(nZero));
            validate_non_negative_index("row_indx_z", "nZero", nZero);
            row_indx_z = std::vector<int>(nZero,int(0));
            vals_i__ = context__.vals_i("row_indx_z");
            pos__ = 0;
            size_t row_indx_z_limit_0__ = nZero;
            for (size_t i_0__ = 0; i_0__ < row_indx_z_limit_0__; ++i_0__) {
                row_indx_z[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("col_indx_z", "nZero", nZero);
            context__.validate_dims("data initialization", "col_indx_z", "int", context__.to_vec(nZero));
            validate_non_negative_index("col_indx_z", "nZero", nZero);
            col_indx_z = std::vector<int>(nZero,int(0));
            vals_i__ = context__.vals_i("col_indx_z");
            pos__ = 0;
            size_t col_indx_z_limit_0__ = nZero;
            for (size_t i_0__ = 0; i_0__ < col_indx_z_limit_0__; ++i_0__) {
                col_indx_z[i_0__] = vals_i__[pos__++];
            }
            context__.validate_dims("data initialization", "n_pos", "int", context__.to_vec());
            n_pos = int(0);
            vals_i__ = context__.vals_i("n_pos");
            pos__ = 0;
            n_pos = vals_i__[pos__++];
            validate_non_negative_index("row_indx_pos", "n_pos", n_pos);
            context__.validate_dims("data initialization", "row_indx_pos", "int", context__.to_vec(n_pos));
            validate_non_negative_index("row_indx_pos", "n_pos", n_pos);
            row_indx_pos = std::vector<int>(n_pos,int(0));
            vals_i__ = context__.vals_i("row_indx_pos");
            pos__ = 0;
            size_t row_indx_pos_limit_0__ = n_pos;
            for (size_t i_0__ = 0; i_0__ < row_indx_pos_limit_0__; ++i_0__) {
                row_indx_pos[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("col_indx_pos", "n_pos", n_pos);
            context__.validate_dims("data initialization", "col_indx_pos", "int", context__.to_vec(n_pos));
            validate_non_negative_index("col_indx_pos", "n_pos", n_pos);
            col_indx_pos = std::vector<int>(n_pos,int(0));
            vals_i__ = context__.vals_i("col_indx_pos");
            pos__ = 0;
            size_t col_indx_pos_limit_0__ = n_pos;
            for (size_t i_0__ = 0; i_0__ < col_indx_pos_limit_0__; ++i_0__) {
                col_indx_pos[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("y", "n_pos", n_pos);
            context__.validate_dims("data initialization", "y", "double", context__.to_vec(n_pos));
            validate_non_negative_index("y", "n_pos", n_pos);
            y = std::vector<double>(n_pos,double(0));
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_limit_0__ = n_pos;
            for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
                y[i_0__] = vals_r__[pos__++];
            }
            context__.validate_dims("data initialization", "n_na", "int", context__.to_vec());
            n_na = int(0);
            vals_i__ = context__.vals_i("n_na");
            pos__ = 0;
            n_na = vals_i__[pos__++];
            validate_non_negative_index("row_indx_na", "n_na", n_na);
            context__.validate_dims("data initialization", "row_indx_na", "int", context__.to_vec(n_na));
            validate_non_negative_index("row_indx_na", "n_na", n_na);
            row_indx_na = std::vector<int>(n_na,int(0));
            vals_i__ = context__.vals_i("row_indx_na");
            pos__ = 0;
            size_t row_indx_na_limit_0__ = n_na;
            for (size_t i_0__ = 0; i_0__ < row_indx_na_limit_0__; ++i_0__) {
                row_indx_na[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("col_indx_na", "n_na", n_na);
            context__.validate_dims("data initialization", "col_indx_na", "int", context__.to_vec(n_na));
            validate_non_negative_index("col_indx_na", "n_na", n_na);
            col_indx_na = std::vector<int>(n_na,int(0));
            vals_i__ = context__.vals_i("col_indx_na");
            pos__ = 0;
            size_t col_indx_na_limit_0__ = n_na;
            for (size_t i_0__ = 0; i_0__ < col_indx_na_limit_0__; ++i_0__) {
                col_indx_na[i_0__] = vals_i__[pos__++];
            }
            context__.validate_dims("data initialization", "nu_fixed", "double", context__.to_vec());
            nu_fixed = double(0);
            vals_r__ = context__.vals_r("nu_fixed");
            pos__ = 0;
            nu_fixed = vals_r__[pos__++];
            context__.validate_dims("data initialization", "num_covar", "int", context__.to_vec());
            num_covar = int(0);
            vals_i__ = context__.vals_i("num_covar");
            pos__ = 0;
            num_covar = vals_i__[pos__++];
            context__.validate_dims("data initialization", "num_unique_covar", "int", context__.to_vec());
            num_unique_covar = int(0);
            vals_i__ = context__.vals_i("num_unique_covar");
            pos__ = 0;
            num_unique_covar = vals_i__[pos__++];
            validate_non_negative_index("d_covar", "num_covar", num_covar);
            validate_non_negative_index("d_covar", "N", N);
            context__.validate_dims("data initialization", "d_covar", "matrix_d", context__.to_vec(num_covar,N));
            validate_non_negative_index("d_covar", "num_covar", num_covar);
            validate_non_negative_index("d_covar", "N", N);
            d_covar = matrix_d(static_cast<Eigen::VectorXd::Index>(num_covar),static_cast<Eigen::VectorXd::Index>(N));
            vals_r__ = context__.vals_r("d_covar");
            pos__ = 0;
            size_t d_covar_m_mat_lim__ = num_covar;
            size_t d_covar_n_mat_lim__ = N;
            for (size_t n_mat__ = 0; n_mat__ < d_covar_n_mat_lim__; ++n_mat__) {
                for (size_t m_mat__ = 0; m_mat__ < d_covar_m_mat_lim__; ++m_mat__) {
                    d_covar(m_mat__,n_mat__) = vals_r__[pos__++];
                }
            }
            validate_non_negative_index("covar_indexing", "P", P);
            validate_non_negative_index("covar_indexing", "num_covar", num_covar);
            context__.validate_dims("data initialization", "covar_indexing", "int", context__.to_vec(P,num_covar));
            validate_non_negative_index("covar_indexing", "P", P);
            validate_non_negative_index("covar_indexing", "num_covar", num_covar);
            covar_indexing = std::vector<std::vector<int> >(P,std::vector<int>(num_covar,int(0)));
            vals_i__ = context__.vals_i("covar_indexing");
            pos__ = 0;
            size_t covar_indexing_limit_1__ = num_covar;
            for (size_t i_1__ = 0; i_1__ < covar_indexing_limit_1__; ++i_1__) {
                size_t covar_indexing_limit_0__ = P;
                for (size_t i_0__ = 0; i_0__ < covar_indexing_limit_0__; ++i_0__) {
                    covar_indexing[i_0__][i_1__] = vals_i__[pos__++];
                }
            }
            context__.validate_dims("data initialization", "estimate_nu", "int", context__.to_vec());
            estimate_nu = int(0);
            vals_i__ = context__.vals_i("estimate_nu");
            pos__ = 0;
            estimate_nu = vals_i__[pos__++];
            context__.validate_dims("data initialization", "use_normal", "int", context__.to_vec());
            use_normal = int(0);
            vals_i__ = context__.vals_i("use_normal");
            pos__ = 0;
            use_normal = vals_i__[pos__++];
            context__.validate_dims("data initialization", "est_cor", "int", context__.to_vec());
            est_cor = int(0);
            vals_i__ = context__.vals_i("est_cor");
            pos__ = 0;
            est_cor = vals_i__[pos__++];
            context__.validate_dims("data initialization", "est_phi", "int", context__.to_vec());
            est_phi = int(0);
            vals_i__ = context__.vals_i("est_phi");
            pos__ = 0;
            est_phi = vals_i__[pos__++];
            context__.validate_dims("data initialization", "est_theta", "int", context__.to_vec());
            est_theta = int(0);
            vals_i__ = context__.vals_i("est_theta");
            pos__ = 0;
            est_theta = vals_i__[pos__++];

            // validate, data variables
            check_greater_or_equal(function__,"N",N,0);
            check_greater_or_equal(function__,"P",P,0);
            check_greater_or_equal(function__,"K",K,0);
            check_greater_or_equal(function__,"nZ",nZ,0);
            for (int k0__ = 0; k0__ < nZ; ++k0__) {
                check_greater_or_equal(function__,"row_indx[k0__]",row_indx[k0__],0);
            }
            for (int k0__ = 0; k0__ < nZ; ++k0__) {
                check_greater_or_equal(function__,"col_indx[k0__]",col_indx[k0__],0);
            }
            check_greater_or_equal(function__,"nVariances",nVariances,0);
            for (int k0__ = 0; k0__ < P; ++k0__) {
                check_greater_or_equal(function__,"varIndx[k0__]",varIndx[k0__],0);
            }
            check_greater_or_equal(function__,"nZero",nZero,0);
            for (int k0__ = 0; k0__ < nZero; ++k0__) {
                check_greater_or_equal(function__,"row_indx_z[k0__]",row_indx_z[k0__],0);
            }
            for (int k0__ = 0; k0__ < nZero; ++k0__) {
                check_greater_or_equal(function__,"col_indx_z[k0__]",col_indx_z[k0__],0);
            }
            check_greater_or_equal(function__,"n_pos",n_pos,0);
            for (int k0__ = 0; k0__ < n_pos; ++k0__) {
                check_greater_or_equal(function__,"row_indx_pos[k0__]",row_indx_pos[k0__],0);
            }
            for (int k0__ = 0; k0__ < n_pos; ++k0__) {
                check_greater_or_equal(function__,"col_indx_pos[k0__]",col_indx_pos[k0__],0);
            }
            check_greater_or_equal(function__,"n_na",n_na,0);
            for (int k0__ = 0; k0__ < n_na; ++k0__) {
                check_greater_or_equal(function__,"row_indx_na[k0__]",row_indx_na[k0__],0);
            }
            for (int k0__ = 0; k0__ < n_na; ++k0__) {
                check_greater_or_equal(function__,"col_indx_na[k0__]",col_indx_na[k0__],0);
            }
            check_greater_or_equal(function__,"nu_fixed",nu_fixed,1);
            check_greater_or_equal(function__,"num_covar",num_covar,0);
            check_greater_or_equal(function__,"num_unique_covar",num_unique_covar,0);
            // initialize data variables
            n_pcor = int(0);
            stan::math::fill(n_pcor, std::numeric_limits<int>::min());
            n_loglik = int(0);
            stan::math::fill(n_loglik, std::numeric_limits<int>::min());
            validate_non_negative_index("zeros", "K", K);
            zeros = vector_d(static_cast<Eigen::VectorXd::Index>(K));
            stan::math::fill(zeros,DUMMY_VAR__);

            for (int k = 1; k <= K; ++k) {

                stan::math::assign(get_base1_lhs(zeros,k,"zeros",1), 0);
            }
            if (as_bool(logical_eq(est_cor,0))) {

                stan::math::assign(n_loglik, (P * N));
            } else {

                stan::math::assign(n_loglik, N);
            }
            if (as_bool(logical_eq(est_cor,0))) {

                stan::math::assign(n_pcor, P);
                if (as_bool(logical_lt(nVariances,2))) {

                    stan::math::assign(n_pcor, 2);
                }
            } else {

                stan::math::assign(n_pcor, P);
            }

            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
        validate_non_negative_index("devs", "K", K);
            validate_non_negative_index("devs", "(N - 1)", (N - 1));
            num_params_r__ += K * (N - 1);
            validate_non_negative_index("x0", "K", K);
            num_params_r__ += K;
            validate_non_negative_index("psi", "K", K);
            num_params_r__ += K;
            validate_non_negative_index("z", "nZ", nZ);
            num_params_r__ += nZ;
            validate_non_negative_index("zpos", "K", K);
            num_params_r__ += K;
            validate_non_negative_index("sigma", "nVariances", nVariances);
            num_params_r__ += nVariances;
            validate_non_negative_index("nu", "estimate_nu", estimate_nu);
            num_params_r__ += estimate_nu;
            validate_non_negative_index("ymiss", "n_na", n_na);
            num_params_r__ += n_na;
            validate_non_negative_index("phi", "(est_phi * K)", (est_phi * K));
            num_params_r__ += (est_phi * K);
            validate_non_negative_index("theta", "(est_theta * K)", (est_theta * K));
            num_params_r__ += (est_theta * K);
            validate_non_negative_index("Lcorr", "n_pcor", n_pcor);
            num_params_r__ += ((n_pcor * (n_pcor - 1)) / 2);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_dfa() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("devs")))
            throw std::runtime_error("variable devs missing");
        vals_r__ = context__.vals_r("devs");
        pos__ = 0U;
        validate_non_negative_index("devs", "K", K);
        validate_non_negative_index("devs", "(N - 1)", (N - 1));
        context__.validate_dims("initialization", "devs", "matrix_d", context__.to_vec(K,(N - 1)));
        matrix_d devs(static_cast<Eigen::VectorXd::Index>(K),static_cast<Eigen::VectorXd::Index>((N - 1)));
        for (int j2__ = 0U; j2__ < (N - 1); ++j2__)
            for (int j1__ = 0U; j1__ < K; ++j1__)
                devs(j1__,j2__) = vals_r__[pos__++];
        try {
            writer__.matrix_unconstrain(devs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable devs: ") + e.what());
        }

        if (!(context__.contains_r("x0")))
            throw std::runtime_error("variable x0 missing");
        vals_r__ = context__.vals_r("x0");
        pos__ = 0U;
        validate_non_negative_index("x0", "K", K);
        context__.validate_dims("initialization", "x0", "vector_d", context__.to_vec(K));
        vector_d x0(static_cast<Eigen::VectorXd::Index>(K));
        for (int j1__ = 0U; j1__ < K; ++j1__)
            x0(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(x0);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable x0: ") + e.what());
        }

        if (!(context__.contains_r("psi")))
            throw std::runtime_error("variable psi missing");
        vals_r__ = context__.vals_r("psi");
        pos__ = 0U;
        validate_non_negative_index("psi", "K", K);
        context__.validate_dims("initialization", "psi", "vector_d", context__.to_vec(K));
        vector_d psi(static_cast<Eigen::VectorXd::Index>(K));
        for (int j1__ = 0U; j1__ < K; ++j1__)
            psi(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,psi);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psi: ") + e.what());
        }

        if (!(context__.contains_r("z")))
            throw std::runtime_error("variable z missing");
        vals_r__ = context__.vals_r("z");
        pos__ = 0U;
        validate_non_negative_index("z", "nZ", nZ);
        context__.validate_dims("initialization", "z", "vector_d", context__.to_vec(nZ));
        vector_d z(static_cast<Eigen::VectorXd::Index>(nZ));
        for (int j1__ = 0U; j1__ < nZ; ++j1__)
            z(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(z);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable z: ") + e.what());
        }

        if (!(context__.contains_r("zpos")))
            throw std::runtime_error("variable zpos missing");
        vals_r__ = context__.vals_r("zpos");
        pos__ = 0U;
        validate_non_negative_index("zpos", "K", K);
        context__.validate_dims("initialization", "zpos", "vector_d", context__.to_vec(K));
        vector_d zpos(static_cast<Eigen::VectorXd::Index>(K));
        for (int j1__ = 0U; j1__ < K; ++j1__)
            zpos(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(zpos);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable zpos: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "nVariances", nVariances);
        context__.validate_dims("initialization", "sigma", "double", context__.to_vec(nVariances));
        std::vector<double> sigma(nVariances,double(0));
        for (int i0__ = 0U; i0__ < nVariances; ++i0__)
            sigma[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < nVariances; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,sigma[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("nu")))
            throw std::runtime_error("variable nu missing");
        vals_r__ = context__.vals_r("nu");
        pos__ = 0U;
        validate_non_negative_index("nu", "estimate_nu", estimate_nu);
        context__.validate_dims("initialization", "nu", "double", context__.to_vec(estimate_nu));
        std::vector<double> nu(estimate_nu,double(0));
        for (int i0__ = 0U; i0__ < estimate_nu; ++i0__)
            nu[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < estimate_nu; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(2,nu[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable nu: ") + e.what());
        }

        if (!(context__.contains_r("ymiss")))
            throw std::runtime_error("variable ymiss missing");
        vals_r__ = context__.vals_r("ymiss");
        pos__ = 0U;
        validate_non_negative_index("ymiss", "n_na", n_na);
        context__.validate_dims("initialization", "ymiss", "double", context__.to_vec(n_na));
        std::vector<double> ymiss(n_na,double(0));
        for (int i0__ = 0U; i0__ < n_na; ++i0__)
            ymiss[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < n_na; ++i0__)
            try {
            writer__.scalar_unconstrain(ymiss[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable ymiss: ") + e.what());
        }

        if (!(context__.contains_r("phi")))
            throw std::runtime_error("variable phi missing");
        vals_r__ = context__.vals_r("phi");
        pos__ = 0U;
        validate_non_negative_index("phi", "(est_phi * K)", (est_phi * K));
        context__.validate_dims("initialization", "phi", "double", context__.to_vec((est_phi * K)));
        std::vector<double> phi((est_phi * K),double(0));
        for (int i0__ = 0U; i0__ < (est_phi * K); ++i0__)
            phi[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < (est_phi * K); ++i0__)
            try {
            writer__.scalar_lub_unconstrain(-(1),1,phi[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable phi: ") + e.what());
        }

        if (!(context__.contains_r("theta")))
            throw std::runtime_error("variable theta missing");
        vals_r__ = context__.vals_r("theta");
        pos__ = 0U;
        validate_non_negative_index("theta", "(est_theta * K)", (est_theta * K));
        context__.validate_dims("initialization", "theta", "double", context__.to_vec((est_theta * K)));
        std::vector<double> theta((est_theta * K),double(0));
        for (int i0__ = 0U; i0__ < (est_theta * K); ++i0__)
            theta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < (est_theta * K); ++i0__)
            try {
            writer__.scalar_lub_unconstrain(-(1),1,theta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable theta: ") + e.what());
        }

        if (!(context__.contains_r("Lcorr")))
            throw std::runtime_error("variable Lcorr missing");
        vals_r__ = context__.vals_r("Lcorr");
        pos__ = 0U;
        validate_non_negative_index("Lcorr", "n_pcor", n_pcor);
        validate_non_negative_index("Lcorr", "n_pcor", n_pcor);
        context__.validate_dims("initialization", "Lcorr", "matrix_d", context__.to_vec(n_pcor,n_pcor));
        matrix_d Lcorr(static_cast<Eigen::VectorXd::Index>(n_pcor),static_cast<Eigen::VectorXd::Index>(n_pcor));
        for (int j2__ = 0U; j2__ < n_pcor; ++j2__)
            for (int j1__ = 0U; j1__ < n_pcor; ++j1__)
                Lcorr(j1__,j2__) = vals_r__[pos__++];
        try {
            writer__.cholesky_corr_unconstrain(Lcorr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable Lcorr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  devs;
            (void) devs;  // dummy to suppress unused var warning
            if (jacobian__)
                devs = in__.matrix_constrain(K,(N - 1),lp__);
            else
                devs = in__.matrix_constrain(K,(N - 1));

            Eigen::Matrix<T__,Eigen::Dynamic,1>  x0;
            (void) x0;  // dummy to suppress unused var warning
            if (jacobian__)
                x0 = in__.vector_constrain(K,lp__);
            else
                x0 = in__.vector_constrain(K);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  psi;
            (void) psi;  // dummy to suppress unused var warning
            if (jacobian__)
                psi = in__.vector_lb_constrain(0,K,lp__);
            else
                psi = in__.vector_lb_constrain(0,K);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  z;
            (void) z;  // dummy to suppress unused var warning
            if (jacobian__)
                z = in__.vector_constrain(nZ,lp__);
            else
                z = in__.vector_constrain(nZ);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  zpos;
            (void) zpos;  // dummy to suppress unused var warning
            if (jacobian__)
                zpos = in__.vector_constrain(K,lp__);
            else
                zpos = in__.vector_constrain(K);

            vector<T__> sigma;
            size_t dim_sigma_0__ = nVariances;
            sigma.reserve(dim_sigma_0__);
            for (size_t k_0__ = 0; k_0__ < dim_sigma_0__; ++k_0__) {
                if (jacobian__)
                    sigma.push_back(in__.scalar_lb_constrain(0,lp__));
                else
                    sigma.push_back(in__.scalar_lb_constrain(0));
            }

            vector<T__> nu;
            size_t dim_nu_0__ = estimate_nu;
            nu.reserve(dim_nu_0__);
            for (size_t k_0__ = 0; k_0__ < dim_nu_0__; ++k_0__) {
                if (jacobian__)
                    nu.push_back(in__.scalar_lb_constrain(2,lp__));
                else
                    nu.push_back(in__.scalar_lb_constrain(2));
            }

            vector<T__> ymiss;
            size_t dim_ymiss_0__ = n_na;
            ymiss.reserve(dim_ymiss_0__);
            for (size_t k_0__ = 0; k_0__ < dim_ymiss_0__; ++k_0__) {
                if (jacobian__)
                    ymiss.push_back(in__.scalar_constrain(lp__));
                else
                    ymiss.push_back(in__.scalar_constrain());
            }

            vector<T__> phi;
            size_t dim_phi_0__ = (est_phi * K);
            phi.reserve(dim_phi_0__);
            for (size_t k_0__ = 0; k_0__ < dim_phi_0__; ++k_0__) {
                if (jacobian__)
                    phi.push_back(in__.scalar_lub_constrain(-(1),1,lp__));
                else
                    phi.push_back(in__.scalar_lub_constrain(-(1),1));
            }

            vector<T__> theta;
            size_t dim_theta_0__ = (est_theta * K);
            theta.reserve(dim_theta_0__);
            for (size_t k_0__ = 0; k_0__ < dim_theta_0__; ++k_0__) {
                if (jacobian__)
                    theta.push_back(in__.scalar_lub_constrain(-(1),1,lp__));
                else
                    theta.push_back(in__.scalar_lub_constrain(-(1),1));
            }

            Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  Lcorr;
            (void) Lcorr;  // dummy to suppress unused var warning
            if (jacobian__)
                Lcorr = in__.cholesky_corr_constrain(n_pcor,lp__);
            else
                Lcorr = in__.cholesky_corr_constrain(n_pcor);


            // transformed parameters
            validate_non_negative_index("pred", "P", P);
            validate_non_negative_index("pred", "N", N);
            Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  pred(static_cast<Eigen::VectorXd::Index>(P),static_cast<Eigen::VectorXd::Index>(N));
            (void) pred;  // dummy to suppress unused var warning

            stan::math::initialize(pred, DUMMY_VAR__);
            stan::math::fill(pred,DUMMY_VAR__);
            validate_non_negative_index("Z", "P", P);
            validate_non_negative_index("Z", "K", K);
            Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  Z(static_cast<Eigen::VectorXd::Index>(P),static_cast<Eigen::VectorXd::Index>(K));
            (void) Z;  // dummy to suppress unused var warning

            stan::math::initialize(Z, DUMMY_VAR__);
            stan::math::fill(Z,DUMMY_VAR__);
            validate_non_negative_index("yall", "P", P);
            validate_non_negative_index("yall", "N", N);
            Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  yall(static_cast<Eigen::VectorXd::Index>(P),static_cast<Eigen::VectorXd::Index>(N));
            (void) yall;  // dummy to suppress unused var warning

            stan::math::initialize(yall, DUMMY_VAR__);
            stan::math::fill(yall,DUMMY_VAR__);
            validate_non_negative_index("sigma_vec", "P", P);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  sigma_vec(static_cast<Eigen::VectorXd::Index>(P));
            (void) sigma_vec;  // dummy to suppress unused var warning

            stan::math::initialize(sigma_vec, DUMMY_VAR__);
            stan::math::fill(sigma_vec,DUMMY_VAR__);
            validate_non_negative_index("phi_vec", "K", K);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  phi_vec(static_cast<Eigen::VectorXd::Index>(K));
            (void) phi_vec;  // dummy to suppress unused var warning

            stan::math::initialize(phi_vec, DUMMY_VAR__);
            stan::math::fill(phi_vec,DUMMY_VAR__);
            validate_non_negative_index("theta_vec", "K", K);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  theta_vec(static_cast<Eigen::VectorXd::Index>(K));
            (void) theta_vec;  // dummy to suppress unused var warning

            stan::math::initialize(theta_vec, DUMMY_VAR__);
            stan::math::fill(theta_vec,DUMMY_VAR__);
            validate_non_negative_index("x", "K", K);
            validate_non_negative_index("x", "N", N);
            Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  x(static_cast<Eigen::VectorXd::Index>(K),static_cast<Eigen::VectorXd::Index>(N));
            (void) x;  // dummy to suppress unused var warning

            stan::math::initialize(x, DUMMY_VAR__);
            stan::math::fill(x,DUMMY_VAR__);
            validate_non_negative_index("indicator", "K", K);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  indicator(static_cast<Eigen::VectorXd::Index>(K));
            (void) indicator;  // dummy to suppress unused var warning

            stan::math::initialize(indicator, DUMMY_VAR__);
            stan::math::fill(indicator,DUMMY_VAR__);
            validate_non_negative_index("psi_root", "K", K);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  psi_root(static_cast<Eigen::VectorXd::Index>(K));
            (void) psi_root;  // dummy to suppress unused var warning

            stan::math::initialize(psi_root, DUMMY_VAR__);
            stan::math::fill(psi_root,DUMMY_VAR__);


            if (as_bool(logical_eq(est_phi,1))) {

                for (int k = 1; k <= K; ++k) {

                    stan::math::assign(get_base1_lhs(phi_vec,k,"phi_vec",1), get_base1(phi,k,"phi",1));
                }
            } else {

                for (int k = 1; k <= K; ++k) {

                    stan::math::assign(get_base1_lhs(phi_vec,k,"phi_vec",1), 1);
                }
            }
            if (as_bool(logical_eq(est_theta,1))) {

                for (int k = 1; k <= K; ++k) {

                    stan::math::assign(get_base1_lhs(theta_vec,k,"theta_vec",1), get_base1(theta,k,"theta",1));
                }
            } else {

                for (int k = 1; k <= K; ++k) {

                    stan::math::assign(get_base1_lhs(theta_vec,k,"theta_vec",1), 0);
                }
            }
            for (int p = 1; p <= P; ++p) {

                stan::math::assign(get_base1_lhs(sigma_vec,p,"sigma_vec",1), get_base1(sigma,get_base1(varIndx,p,"varIndx",1),"sigma",1));
            }
            for (int i = 1; i <= n_pos; ++i) {

                stan::math::assign(get_base1_lhs(yall,get_base1(row_indx_pos,i,"row_indx_pos",1),get_base1(col_indx_pos,i,"col_indx_pos",1),"yall",1), get_base1(y,i,"y",1));
            }
            if (as_bool(logical_gt(n_na,0))) {

                for (int i = 1; i <= n_na; ++i) {

                    stan::math::assign(get_base1_lhs(yall,get_base1(row_indx_na,i,"row_indx_na",1),get_base1(col_indx_na,i,"col_indx_na",1),"yall",1), get_base1(ymiss,i,"ymiss",1));
                }
            }
            for (int i = 1; i <= nZ; ++i) {

                stan::math::assign(get_base1_lhs(Z,get_base1(row_indx,i,"row_indx",1),get_base1(col_indx,i,"col_indx",1),"Z",1), get_base1(z,i,"z",1));
            }
            if (as_bool(logical_gt(nZero,2))) {

                for (int i = 1; i <= (nZero - 2); ++i) {

                    stan::math::assign(get_base1_lhs(Z,get_base1(row_indx_z,i,"row_indx_z",1),get_base1(col_indx_z,i,"col_indx_z",1),"Z",1), 0);
                }
            }
            for (int k = 1; k <= K; ++k) {

                stan::math::assign(get_base1_lhs(Z,k,k,"Z",1), get_base1(zpos,k,"zpos",1));
            }
            for (int k = 1; k <= K; ++k) {

                if (as_bool(logical_lt(get_base1(zpos,k,"zpos",1),0))) {

                    stan::math::assign(get_base1_lhs(indicator,k,"indicator",1), -(1));
                } else {

                    stan::math::assign(get_base1_lhs(indicator,k,"indicator",1), 1);
                }
                stan::math::assign(get_base1_lhs(psi_root,k,"psi_root",1), sqrt(get_base1(psi,k,"psi",1)));
                for (int p = 1; p <= P; ++p) {

                    stan::math::assign(get_base1_lhs(Z,p,k,"Z",1), ((get_base1(Z,p,k,"Z",1) * get_base1(indicator,k,"indicator",1)) * (1 / get_base1(psi_root,k,"psi_root",1))));
                }
            }
            for (int k = 1; k <= K; ++k) {

                stan::math::assign(get_base1_lhs(x,k,1,"x",1), get_base1(x0,k,"x0",1));
                for (int t = 2; t <= N; ++t) {

                    stan::math::assign(get_base1_lhs(x,k,t,"x",1), ((get_base1(phi_vec,k,"phi_vec",1) * get_base1(x,k,(t - 1),"x",1)) + get_base1(devs,k,(t - 1),"devs",1)));
                }
            }
            for (int k = 1; k <= K; ++k) {

                for (int t = 1; t <= N; ++t) {

                    stan::math::assign(get_base1_lhs(x,k,t,"x",1), ((get_base1(x,k,t,"x",1) * get_base1(indicator,k,"indicator",1)) * get_base1(psi_root,k,"psi_root",1)));
                }
            }
            stan::math::assign(pred, multiply(Z,x));

            // validate transformed parameters
            for (int i0__ = 0; i0__ < P; ++i0__) {
                for (int i1__ = 0; i1__ < N; ++i1__) {
                    if (stan::math::is_uninitialized(pred(i0__,i1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: pred" << '[' << i0__ << ']' << '[' << i1__ << ']';
                        throw std::runtime_error(msg__.str());
                    }
                }
            }
            for (int i0__ = 0; i0__ < P; ++i0__) {
                for (int i1__ = 0; i1__ < K; ++i1__) {
                    if (stan::math::is_uninitialized(Z(i0__,i1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: Z" << '[' << i0__ << ']' << '[' << i1__ << ']';
                        throw std::runtime_error(msg__.str());
                    }
                }
            }
            for (int i0__ = 0; i0__ < P; ++i0__) {
                for (int i1__ = 0; i1__ < N; ++i1__) {
                    if (stan::math::is_uninitialized(yall(i0__,i1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: yall" << '[' << i0__ << ']' << '[' << i1__ << ']';
                        throw std::runtime_error(msg__.str());
                    }
                }
            }
            for (int i0__ = 0; i0__ < P; ++i0__) {
                if (stan::math::is_uninitialized(sigma_vec(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: sigma_vec" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < K; ++i0__) {
                if (stan::math::is_uninitialized(phi_vec(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: phi_vec" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < K; ++i0__) {
                if (stan::math::is_uninitialized(theta_vec(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: theta_vec" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < K; ++i0__) {
                for (int i1__ = 0; i1__ < N; ++i1__) {
                    if (stan::math::is_uninitialized(x(i0__,i1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: x" << '[' << i0__ << ']' << '[' << i1__ << ']';
                        throw std::runtime_error(msg__.str());
                    }
                }
            }
            for (int i0__ = 0; i0__ < K; ++i0__) {
                if (stan::math::is_uninitialized(indicator(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: indicator" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < K; ++i0__) {
                if (stan::math::is_uninitialized(psi_root(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: psi_root" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            // model body

            lp_accum__.add(normal_log<propto__>(x0, 0, 1));
            lp_accum__.add(gamma_log<propto__>(psi, 2, 1));
            for (int k = 1; k <= K; ++k) {

                if (as_bool(logical_eq(use_normal,0))) {

                    for (int t = 1; t <= 1; ++t) {

                        if (as_bool(logical_eq(estimate_nu,1))) {

                            lp_accum__.add(student_t_log<propto__>(get_base1(devs,k,t,"devs",1), get_base1(nu,1,"nu",1), 0, 1));
                        } else {

                            lp_accum__.add(student_t_log<propto__>(get_base1(devs,k,t,"devs",1), nu_fixed, 0, 1));
                        }
                    }
                    for (int t = 2; t <= (N - 1); ++t) {

                        if (as_bool(logical_eq(estimate_nu,1))) {

                            lp_accum__.add(student_t_log<propto__>(get_base1(devs,k,t,"devs",1), get_base1(nu,1,"nu",1), (get_base1(theta_vec,k,"theta_vec",1) * get_base1(devs,k,(t - 1),"devs",1)), 1));
                        } else {

                            lp_accum__.add(student_t_log<propto__>(get_base1(devs,k,t,"devs",1), nu_fixed, (get_base1(theta_vec,k,"theta_vec",1) * get_base1(devs,k,(t - 1),"devs",1)), 1));
                        }
                    }
                } else {

                    lp_accum__.add(normal_log<propto__>(get_base1(devs,k,1,"devs",1), 0, 1));
                    for (int t = 2; t <= (N - 1); ++t) {

                        lp_accum__.add(normal_log<propto__>(get_base1(devs,k,t,"devs",1), (get_base1(theta_vec,k,"theta_vec",1) * get_base1(devs,k,(t - 1),"devs",1)), 1));
                    }
                }
            }
            if (as_bool(logical_eq(estimate_nu,1))) {

                lp_accum__.add(gamma_log<propto__>(get_base1(nu,1,"nu",1), 2, 0.10000000000000001));
            }
            if (as_bool(logical_eq(est_phi,1))) {

                lp_accum__.add(uniform_log<propto__>(phi, 0, 1));
            }
            if (as_bool(logical_eq(est_theta,1))) {

                lp_accum__.add(uniform_log<propto__>(theta, 0, 1));
            }
            lp_accum__.add(normal_log<propto__>(z, 0, 1));
            lp_accum__.add(normal_log<propto__>(zpos, 0, 1));
            lp_accum__.add(student_t_log<propto__>(sigma, 3, 0, 2));
            if (as_bool(logical_eq(est_cor,1))) {

                lp_accum__.add(lkj_corr_cholesky_log<propto__>(Lcorr, 1));
            }
            if (as_bool(logical_eq(est_cor,0))) {

                for (int i = 1; i <= P; ++i) {

                    lp_accum__.add(normal_log(get_base1(yall,i,"yall",1),get_base1(pred,i,"pred",1),get_base1(sigma_vec,i,"sigma_vec",1)));
                }
            } else {

                for (int i = 1; i <= N; ++i) {

                    lp_accum__.add(multi_normal_cholesky_log(col(yall,i),col(pred,i),diag_pre_multiply(sigma_vec,Lcorr)));
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("devs");
        names__.push_back("x0");
        names__.push_back("psi");
        names__.push_back("z");
        names__.push_back("zpos");
        names__.push_back("sigma");
        names__.push_back("nu");
        names__.push_back("ymiss");
        names__.push_back("phi");
        names__.push_back("theta");
        names__.push_back("Lcorr");
        names__.push_back("pred");
        names__.push_back("Z");
        names__.push_back("yall");
        names__.push_back("sigma_vec");
        names__.push_back("phi_vec");
        names__.push_back("theta_vec");
        names__.push_back("x");
        names__.push_back("indicator");
        names__.push_back("psi_root");
        names__.push_back("log_lik");
        names__.push_back("Omega");
        names__.push_back("Sigma");
        names__.push_back("j");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back((N - 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nZ);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nVariances);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(estimate_nu);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_na);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((est_phi * K));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((est_theta * K));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_pcor);
        dims__.push_back(n_pcor);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(P);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(P);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(P);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(P);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_loglik);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_pcor);
        dims__.push_back(n_pcor);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_pcor);
        dims__.push_back(n_pcor);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_dfa_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        matrix_d devs = in__.matrix_constrain(K,(N - 1));
        vector_d x0 = in__.vector_constrain(K);
        vector_d psi = in__.vector_lb_constrain(0,K);
        vector_d z = in__.vector_constrain(nZ);
        vector_d zpos = in__.vector_constrain(K);
        vector<double> sigma;
        size_t dim_sigma_0__ = nVariances;
        for (size_t k_0__ = 0; k_0__ < dim_sigma_0__; ++k_0__) {
            sigma.push_back(in__.scalar_lb_constrain(0));
        }
        vector<double> nu;
        size_t dim_nu_0__ = estimate_nu;
        for (size_t k_0__ = 0; k_0__ < dim_nu_0__; ++k_0__) {
            nu.push_back(in__.scalar_lb_constrain(2));
        }
        vector<double> ymiss;
        size_t dim_ymiss_0__ = n_na;
        for (size_t k_0__ = 0; k_0__ < dim_ymiss_0__; ++k_0__) {
            ymiss.push_back(in__.scalar_constrain());
        }
        vector<double> phi;
        size_t dim_phi_0__ = (est_phi * K);
        for (size_t k_0__ = 0; k_0__ < dim_phi_0__; ++k_0__) {
            phi.push_back(in__.scalar_lub_constrain(-(1),1));
        }
        vector<double> theta;
        size_t dim_theta_0__ = (est_theta * K);
        for (size_t k_0__ = 0; k_0__ < dim_theta_0__; ++k_0__) {
            theta.push_back(in__.scalar_lub_constrain(-(1),1));
        }
        matrix_d Lcorr = in__.cholesky_corr_constrain(n_pcor);
            for (int k_1__ = 0; k_1__ < (N - 1); ++k_1__) {
                for (int k_0__ = 0; k_0__ < K; ++k_0__) {
                vars__.push_back(devs(k_0__, k_1__));
                }
            }
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(x0[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(psi[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nZ; ++k_0__) {
            vars__.push_back(z[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(zpos[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nVariances; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < estimate_nu; ++k_0__) {
            vars__.push_back(nu[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < n_na; ++k_0__) {
            vars__.push_back(ymiss[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < (est_phi * K); ++k_0__) {
            vars__.push_back(phi[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < (est_theta * K); ++k_0__) {
            vars__.push_back(theta[k_0__]);
            }
            for (int k_1__ = 0; k_1__ < n_pcor; ++k_1__) {
                for (int k_0__ = 0; k_0__ < n_pcor; ++k_0__) {
                vars__.push_back(Lcorr(k_0__, k_1__));
                }
            }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            validate_non_negative_index("pred", "P", P);
            validate_non_negative_index("pred", "N", N);
            matrix_d pred(static_cast<Eigen::VectorXd::Index>(P),static_cast<Eigen::VectorXd::Index>(N));
            (void) pred;  // dummy to suppress unused var warning

            stan::math::initialize(pred, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pred,DUMMY_VAR__);
            validate_non_negative_index("Z", "P", P);
            validate_non_negative_index("Z", "K", K);
            matrix_d Z(static_cast<Eigen::VectorXd::Index>(P),static_cast<Eigen::VectorXd::Index>(K));
            (void) Z;  // dummy to suppress unused var warning

            stan::math::initialize(Z, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(Z,DUMMY_VAR__);
            validate_non_negative_index("yall", "P", P);
            validate_non_negative_index("yall", "N", N);
            matrix_d yall(static_cast<Eigen::VectorXd::Index>(P),static_cast<Eigen::VectorXd::Index>(N));
            (void) yall;  // dummy to suppress unused var warning

            stan::math::initialize(yall, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(yall,DUMMY_VAR__);
            validate_non_negative_index("sigma_vec", "P", P);
            vector_d sigma_vec(static_cast<Eigen::VectorXd::Index>(P));
            (void) sigma_vec;  // dummy to suppress unused var warning

            stan::math::initialize(sigma_vec, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(sigma_vec,DUMMY_VAR__);
            validate_non_negative_index("phi_vec", "K", K);
            vector_d phi_vec(static_cast<Eigen::VectorXd::Index>(K));
            (void) phi_vec;  // dummy to suppress unused var warning

            stan::math::initialize(phi_vec, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(phi_vec,DUMMY_VAR__);
            validate_non_negative_index("theta_vec", "K", K);
            vector_d theta_vec(static_cast<Eigen::VectorXd::Index>(K));
            (void) theta_vec;  // dummy to suppress unused var warning

            stan::math::initialize(theta_vec, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(theta_vec,DUMMY_VAR__);
            validate_non_negative_index("x", "K", K);
            validate_non_negative_index("x", "N", N);
            matrix_d x(static_cast<Eigen::VectorXd::Index>(K),static_cast<Eigen::VectorXd::Index>(N));
            (void) x;  // dummy to suppress unused var warning

            stan::math::initialize(x, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(x,DUMMY_VAR__);
            validate_non_negative_index("indicator", "K", K);
            vector_d indicator(static_cast<Eigen::VectorXd::Index>(K));
            (void) indicator;  // dummy to suppress unused var warning

            stan::math::initialize(indicator, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(indicator,DUMMY_VAR__);
            validate_non_negative_index("psi_root", "K", K);
            vector_d psi_root(static_cast<Eigen::VectorXd::Index>(K));
            (void) psi_root;  // dummy to suppress unused var warning

            stan::math::initialize(psi_root, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(psi_root,DUMMY_VAR__);


            if (as_bool(logical_eq(est_phi,1))) {

                for (int k = 1; k <= K; ++k) {

                    stan::math::assign(get_base1_lhs(phi_vec,k,"phi_vec",1), get_base1(phi,k,"phi",1));
                }
            } else {

                for (int k = 1; k <= K; ++k) {

                    stan::math::assign(get_base1_lhs(phi_vec,k,"phi_vec",1), 1);
                }
            }
            if (as_bool(logical_eq(est_theta,1))) {

                for (int k = 1; k <= K; ++k) {

                    stan::math::assign(get_base1_lhs(theta_vec,k,"theta_vec",1), get_base1(theta,k,"theta",1));
                }
            } else {

                for (int k = 1; k <= K; ++k) {

                    stan::math::assign(get_base1_lhs(theta_vec,k,"theta_vec",1), 0);
                }
            }
            for (int p = 1; p <= P; ++p) {

                stan::math::assign(get_base1_lhs(sigma_vec,p,"sigma_vec",1), get_base1(sigma,get_base1(varIndx,p,"varIndx",1),"sigma",1));
            }
            for (int i = 1; i <= n_pos; ++i) {

                stan::math::assign(get_base1_lhs(yall,get_base1(row_indx_pos,i,"row_indx_pos",1),get_base1(col_indx_pos,i,"col_indx_pos",1),"yall",1), get_base1(y,i,"y",1));
            }
            if (as_bool(logical_gt(n_na,0))) {

                for (int i = 1; i <= n_na; ++i) {

                    stan::math::assign(get_base1_lhs(yall,get_base1(row_indx_na,i,"row_indx_na",1),get_base1(col_indx_na,i,"col_indx_na",1),"yall",1), get_base1(ymiss,i,"ymiss",1));
                }
            }
            for (int i = 1; i <= nZ; ++i) {

                stan::math::assign(get_base1_lhs(Z,get_base1(row_indx,i,"row_indx",1),get_base1(col_indx,i,"col_indx",1),"Z",1), get_base1(z,i,"z",1));
            }
            if (as_bool(logical_gt(nZero,2))) {

                for (int i = 1; i <= (nZero - 2); ++i) {

                    stan::math::assign(get_base1_lhs(Z,get_base1(row_indx_z,i,"row_indx_z",1),get_base1(col_indx_z,i,"col_indx_z",1),"Z",1), 0);
                }
            }
            for (int k = 1; k <= K; ++k) {

                stan::math::assign(get_base1_lhs(Z,k,k,"Z",1), get_base1(zpos,k,"zpos",1));
            }
            for (int k = 1; k <= K; ++k) {

                if (as_bool(logical_lt(get_base1(zpos,k,"zpos",1),0))) {

                    stan::math::assign(get_base1_lhs(indicator,k,"indicator",1), -(1));
                } else {

                    stan::math::assign(get_base1_lhs(indicator,k,"indicator",1), 1);
                }
                stan::math::assign(get_base1_lhs(psi_root,k,"psi_root",1), sqrt(get_base1(psi,k,"psi",1)));
                for (int p = 1; p <= P; ++p) {

                    stan::math::assign(get_base1_lhs(Z,p,k,"Z",1), ((get_base1(Z,p,k,"Z",1) * get_base1(indicator,k,"indicator",1)) * (1 / get_base1(psi_root,k,"psi_root",1))));
                }
            }
            for (int k = 1; k <= K; ++k) {

                stan::math::assign(get_base1_lhs(x,k,1,"x",1), get_base1(x0,k,"x0",1));
                for (int t = 2; t <= N; ++t) {

                    stan::math::assign(get_base1_lhs(x,k,t,"x",1), ((get_base1(phi_vec,k,"phi_vec",1) * get_base1(x,k,(t - 1),"x",1)) + get_base1(devs,k,(t - 1),"devs",1)));
                }
            }
            for (int k = 1; k <= K; ++k) {

                for (int t = 1; t <= N; ++t) {

                    stan::math::assign(get_base1_lhs(x,k,t,"x",1), ((get_base1(x,k,t,"x",1) * get_base1(indicator,k,"indicator",1)) * get_base1(psi_root,k,"psi_root",1)));
                }
            }
            stan::math::assign(pred, multiply(Z,x));

            // validate transformed parameters

            // write transformed parameters
            for (int k_1__ = 0; k_1__ < N; ++k_1__) {
                for (int k_0__ = 0; k_0__ < P; ++k_0__) {
                vars__.push_back(pred(k_0__, k_1__));
                }
            }
            for (int k_1__ = 0; k_1__ < K; ++k_1__) {
                for (int k_0__ = 0; k_0__ < P; ++k_0__) {
                vars__.push_back(Z(k_0__, k_1__));
                }
            }
            for (int k_1__ = 0; k_1__ < N; ++k_1__) {
                for (int k_0__ = 0; k_0__ < P; ++k_0__) {
                vars__.push_back(yall(k_0__, k_1__));
                }
            }
            for (int k_0__ = 0; k_0__ < P; ++k_0__) {
            vars__.push_back(sigma_vec[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(phi_vec[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(theta_vec[k_0__]);
            }
            for (int k_1__ = 0; k_1__ < N; ++k_1__) {
                for (int k_0__ = 0; k_0__ < K; ++k_0__) {
                vars__.push_back(x(k_0__, k_1__));
                }
            }
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(indicator[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(psi_root[k_0__]);
            }

            if (!include_gqs__) return;
            // declare and define generated quantities
            validate_non_negative_index("log_lik", "n_loglik", n_loglik);
            vector_d log_lik(static_cast<Eigen::VectorXd::Index>(n_loglik));
            (void) log_lik;  // dummy to suppress unused var warning

            stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(log_lik,DUMMY_VAR__);
            validate_non_negative_index("Omega", "n_pcor", n_pcor);
            validate_non_negative_index("Omega", "n_pcor", n_pcor);
            matrix_d Omega(static_cast<Eigen::VectorXd::Index>(n_pcor),static_cast<Eigen::VectorXd::Index>(n_pcor));
            (void) Omega;  // dummy to suppress unused var warning

            stan::math::initialize(Omega, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(Omega,DUMMY_VAR__);
            validate_non_negative_index("Sigma", "n_pcor", n_pcor);
            validate_non_negative_index("Sigma", "n_pcor", n_pcor);
            matrix_d Sigma(static_cast<Eigen::VectorXd::Index>(n_pcor),static_cast<Eigen::VectorXd::Index>(n_pcor));
            (void) Sigma;  // dummy to suppress unused var warning

            stan::math::initialize(Sigma, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(Sigma,DUMMY_VAR__);
            int j(0);
            (void) j;  // dummy to suppress unused var warning

            stan::math::fill(j, std::numeric_limits<int>::min());


            if (as_bool(logical_eq(est_cor,1))) {

                stan::math::assign(Omega, multiply_lower_tri_self_transpose(Lcorr));
                stan::math::assign(Sigma, quad_form_diag(Omega,sigma_vec));
            }
            if (as_bool(logical_eq(est_cor,0))) {

                stan::math::assign(j, 0);
                for (int n = 1; n <= N; ++n) {

                    for (int p = 1; p <= P; ++p) {

                        stan::math::assign(j, (j + 1));
                        stan::math::assign(get_base1_lhs(log_lik,j,"log_lik",1), normal_log(get_base1(yall,p,n,"yall",1),get_base1(pred,p,n,"pred",1),get_base1(sigma_vec,p,"sigma_vec",1)));
                    }
                }
            } else {

                for (int i = 1; i <= N; ++i) {

                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), multi_normal_cholesky_log(col(yall,i),col(pred,i),diag_pre_multiply(sigma_vec,Lcorr)));
                }
            }

            // validate generated quantities
            check_greater_or_equal(function__,"j",j,0);

            // write generated quantities
            for (int k_0__ = 0; k_0__ < n_loglik; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
            }
            for (int k_1__ = 0; k_1__ < n_pcor; ++k_1__) {
                for (int k_0__ = 0; k_0__ < n_pcor; ++k_0__) {
                vars__.push_back(Omega(k_0__, k_1__));
                }
            }
            for (int k_1__ = 0; k_1__ < n_pcor; ++k_1__) {
                for (int k_0__ = 0; k_0__ < n_pcor; ++k_0__) {
                vars__.push_back(Sigma(k_0__, k_1__));
                }
            }
        vars__.push_back(j);

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_dfa";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_1__ = 1; k_1__ <= (N - 1); ++k_1__) {
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "devs" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "x0" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nZ; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "zpos" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nVariances; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= estimate_nu; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_na; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ymiss" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (est_phi * K); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (est_theta * K); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= n_pcor; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= n_pcor; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Lcorr" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_1__ = 1; k_1__ <= N; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= P; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "pred" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= P; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Z" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= N; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= P; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "yall" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= P; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_vec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi_vec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_vec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= N; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "x" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "indicator" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_root" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= n_loglik; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= n_pcor; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= n_pcor; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Omega" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= n_pcor; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= n_pcor; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Sigma" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "j";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_1__ = 1; k_1__ <= (N - 1); ++k_1__) {
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "devs" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "x0" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nZ; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "zpos" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nVariances; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= estimate_nu; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_na; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ymiss" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (est_phi * K); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= (est_theta * K); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= ((n_pcor * (n_pcor - 1)) / 2); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Lcorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_1__ = 1; k_1__ <= N; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= P; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "pred" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= P; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Z" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= N; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= P; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "yall" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= P; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_vec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi_vec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_vec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= N; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "x" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "indicator" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi_root" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= n_loglik; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= n_pcor; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= n_pcor; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Omega" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= n_pcor; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= n_pcor; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Sigma" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "j";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

}




// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_hmm_gaussian_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_hmm_gaussian");
    reader.add_event(178, 178, "end", "model_hmm_gaussian");
    return reader;
}

template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic,1>
normalize(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& x, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {

        return stan::math::promote_scalar<fun_return_scalar_t__>(divide(x,sum(x)));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct normalize_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic,1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& x, std::ostream* pstream__) const {
        return normalize(x, pstream__);
    }
};

class model_hmm_gaussian : public prob_grad {
private:
    int T;
    int K;
    vector<double> x_t;
    int est_sigma;
    vector<double> sigma_t;
public:
    model_hmm_gaussian(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_hmm_gaussian(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_hmm_gaussian_namespace::model_hmm_gaussian";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            validate_non_negative_index("x_t", "T", T);
            context__.validate_dims("data initialization", "x_t", "double", context__.to_vec(T));
            validate_non_negative_index("x_t", "T", T);
            x_t = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("x_t");
            pos__ = 0;
            size_t x_t_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < x_t_limit_0__; ++i_0__) {
                x_t[i_0__] = vals_r__[pos__++];
            }
            context__.validate_dims("data initialization", "est_sigma", "int", context__.to_vec());
            est_sigma = int(0);
            vals_i__ = context__.vals_i("est_sigma");
            pos__ = 0;
            est_sigma = vals_i__[pos__++];
            validate_non_negative_index("sigma_t", "T", T);
            context__.validate_dims("data initialization", "sigma_t", "double", context__.to_vec(T));
            validate_non_negative_index("sigma_t", "T", T);
            sigma_t = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("sigma_t");
            pos__ = 0;
            size_t sigma_t_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < sigma_t_limit_0__; ++i_0__) {
                sigma_t[i_0__] = vals_r__[pos__++];
            }

            // validate, data variables
            check_greater_or_equal(function__,"T",T,1);
            check_greater_or_equal(function__,"K",K,1);
            check_greater_or_equal(function__,"est_sigma",est_sigma,0);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            validate_non_negative_index("p_1k", "K", K);
            num_params_r__ += (K - 1);
            validate_non_negative_index("A_ij", "K", K);
            validate_non_negative_index("A_ij", "K", K);
            num_params_r__ += (K - 1) * K;
            validate_non_negative_index("mu_k", "K", K);
            num_params_r__ += K;
            validate_non_negative_index("sigma_k", "K", K);
            num_params_r__ += K;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_hmm_gaussian() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("p_1k")))
            throw std::runtime_error("variable p_1k missing");
        vals_r__ = context__.vals_r("p_1k");
        pos__ = 0U;
        validate_non_negative_index("p_1k", "K", K);
        context__.validate_dims("initialization", "p_1k", "vector_d", context__.to_vec(K));
        vector_d p_1k(static_cast<Eigen::VectorXd::Index>(K));
        for (int j1__ = 0U; j1__ < K; ++j1__)
            p_1k(j1__) = vals_r__[pos__++];
        try {
            writer__.simplex_unconstrain(p_1k);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable p_1k: ") + e.what());
        }

        if (!(context__.contains_r("A_ij")))
            throw std::runtime_error("variable A_ij missing");
        vals_r__ = context__.vals_r("A_ij");
        pos__ = 0U;
        validate_non_negative_index("A_ij", "K", K);
        validate_non_negative_index("A_ij", "K", K);
        context__.validate_dims("initialization", "A_ij", "vector_d", context__.to_vec(K,K));
        std::vector<vector_d> A_ij(K,vector_d(static_cast<Eigen::VectorXd::Index>(K)));
        for (int j1__ = 0U; j1__ < K; ++j1__)
            for (int i0__ = 0U; i0__ < K; ++i0__)
                A_ij[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < K; ++i0__)
            try {
            writer__.simplex_unconstrain(A_ij[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable A_ij: ") + e.what());
        }

        if (!(context__.contains_r("mu_k")))
            throw std::runtime_error("variable mu_k missing");
        vals_r__ = context__.vals_r("mu_k");
        pos__ = 0U;
        validate_non_negative_index("mu_k", "K", K);
        context__.validate_dims("initialization", "mu_k", "vector_d", context__.to_vec(K));
        vector_d mu_k(static_cast<Eigen::VectorXd::Index>(K));
        for (int j1__ = 0U; j1__ < K; ++j1__)
            mu_k(j1__) = vals_r__[pos__++];
        try {
            writer__.ordered_unconstrain(mu_k);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_k: ") + e.what());
        }

        if (!(context__.contains_r("sigma_k")))
            throw std::runtime_error("variable sigma_k missing");
        vals_r__ = context__.vals_r("sigma_k");
        pos__ = 0U;
        validate_non_negative_index("sigma_k", "K", K);
        context__.validate_dims("initialization", "sigma_k", "double", context__.to_vec(K));
        std::vector<double> sigma_k(K,double(0));
        for (int i0__ = 0U; i0__ < K; ++i0__)
            sigma_k[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < K; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,sigma_k[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_k: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            Eigen::Matrix<T__,Eigen::Dynamic,1>  p_1k;
            (void) p_1k;  // dummy to suppress unused var warning
            if (jacobian__)
                p_1k = in__.simplex_constrain(K,lp__);
            else
                p_1k = in__.simplex_constrain(K);

            vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > A_ij;
            size_t dim_A_ij_0__ = K;
            A_ij.reserve(dim_A_ij_0__);
            for (size_t k_0__ = 0; k_0__ < dim_A_ij_0__; ++k_0__) {
                if (jacobian__)
                    A_ij.push_back(in__.simplex_constrain(K,lp__));
                else
                    A_ij.push_back(in__.simplex_constrain(K));
            }

            Eigen::Matrix<T__,Eigen::Dynamic,1>  mu_k;
            (void) mu_k;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_k = in__.ordered_constrain(K,lp__);
            else
                mu_k = in__.ordered_constrain(K);

            vector<T__> sigma_k;
            size_t dim_sigma_k_0__ = K;
            sigma_k.reserve(dim_sigma_k_0__);
            for (size_t k_0__ = 0; k_0__ < dim_sigma_k_0__; ++k_0__) {
                if (jacobian__)
                    sigma_k.push_back(in__.scalar_lb_constrain(0,lp__));
                else
                    sigma_k.push_back(in__.scalar_lb_constrain(0));
            }


            // transformed parameters
            validate_non_negative_index("unalpha_tk", "K", K);
            validate_non_negative_index("unalpha_tk", "T", T);
            vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > unalpha_tk(T, (Eigen::Matrix<T__,Eigen::Dynamic,1> (static_cast<Eigen::VectorXd::Index>(K))));
            stan::math::initialize(unalpha_tk, DUMMY_VAR__);
            stan::math::fill(unalpha_tk,DUMMY_VAR__);


            {
            validate_non_negative_index("accumulator", "K", K);
            vector<T__> accumulator(K);
            stan::math::initialize(accumulator, DUMMY_VAR__);
            stan::math::fill(accumulator,DUMMY_VAR__);


            if (as_bool(logical_eq(est_sigma,1))) {

                stan::math::assign(get_base1_lhs(unalpha_tk,1,"unalpha_tk",1), add(log(p_1k),normal_log(get_base1(x_t,1,"x_t",1),mu_k,sigma_k)));
            } else {

                stan::math::assign(get_base1_lhs(unalpha_tk,1,"unalpha_tk",1), add(log(p_1k),normal_log(get_base1(x_t,1,"x_t",1),mu_k,get_base1(sigma_t,1,"sigma_t",1))));
            }
            for (int t = 2; t <= T; ++t) {

                for (int j = 1; j <= K; ++j) {

                    for (int i = 1; i <= K; ++i) {

                        if (as_bool(logical_eq(est_sigma,1))) {

                            stan::math::assign(get_base1_lhs(accumulator,i,"accumulator",1), ((get_base1(get_base1(unalpha_tk,(t - 1),"unalpha_tk",1),i,"unalpha_tk",2) + log(get_base1(get_base1(A_ij,i,"A_ij",1),j,"A_ij",2))) + normal_log(get_base1(x_t,t,"x_t",1),get_base1(mu_k,j,"mu_k",1),get_base1(sigma_k,j,"sigma_k",1))));
                        } else {

                            stan::math::assign(get_base1_lhs(accumulator,i,"accumulator",1), ((get_base1(get_base1(unalpha_tk,(t - 1),"unalpha_tk",1),i,"unalpha_tk",2) + log(get_base1(get_base1(A_ij,i,"A_ij",1),j,"A_ij",2))) + normal_log(get_base1(x_t,t,"x_t",1),get_base1(mu_k,j,"mu_k",1),get_base1(sigma_t,t,"sigma_t",1))));
                        }
                    }
                    stan::math::assign(get_base1_lhs(get_base1_lhs(unalpha_tk,t,"unalpha_tk",1),j,"unalpha_tk",2), log_sum_exp(accumulator));
                }
            }
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < T; ++i0__) {
                for (int i1__ = 0; i1__ < K; ++i1__) {
                    if (stan::math::is_uninitialized(unalpha_tk[i0__](i1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: unalpha_tk" << '[' << i0__ << ']' << '[' << i1__ << ']';
                        throw std::runtime_error(msg__.str());
                    }
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            // model body

            lp_accum__.add(student_t_log<propto__>(sigma_k, 3, 0, 1));
            lp_accum__.add(student_t_log<propto__>(mu_k, 3, 0, 3));
            lp_accum__.add(log_sum_exp(get_base1(unalpha_tk,T,"unalpha_tk",1)));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("p_1k");
        names__.push_back("A_ij");
        names__.push_back("mu_k");
        names__.push_back("sigma_k");
        names__.push_back("unalpha_tk");
        names__.push_back("unbeta_tk");
        names__.push_back("ungamma_tk");
        names__.push_back("alpha_tk");
        names__.push_back("beta_tk");
        names__.push_back("gamma_tk");
        names__.push_back("log_lik");
        names__.push_back("zstar_t");
        names__.push_back("logp_zstar_t");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_hmm_gaussian_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d p_1k = in__.simplex_constrain(K);
        vector<vector_d> A_ij;
        size_t dim_A_ij_0__ = K;
        for (size_t k_0__ = 0; k_0__ < dim_A_ij_0__; ++k_0__) {
            A_ij.push_back(in__.simplex_constrain(K));
        }
        vector_d mu_k = in__.ordered_constrain(K);
        vector<double> sigma_k;
        size_t dim_sigma_k_0__ = K;
        for (size_t k_0__ = 0; k_0__ < dim_sigma_k_0__; ++k_0__) {
            sigma_k.push_back(in__.scalar_lb_constrain(0));
        }
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(p_1k[k_0__]);
            }
            for (int k_1__ = 0; k_1__ < K; ++k_1__) {
                for (int k_0__ = 0; k_0__ < K; ++k_0__) {
                vars__.push_back(A_ij[k_0__][k_1__]);
                }
            }
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(mu_k[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(sigma_k[k_0__]);
            }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            validate_non_negative_index("unalpha_tk", "K", K);
            validate_non_negative_index("unalpha_tk", "T", T);
            vector<vector_d> unalpha_tk(T, (vector_d(static_cast<Eigen::VectorXd::Index>(K))));
            stan::math::initialize(unalpha_tk, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(unalpha_tk,DUMMY_VAR__);


            {
            validate_non_negative_index("accumulator", "K", K);
            vector<double> accumulator(K, 0.0);
            stan::math::initialize(accumulator, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(accumulator,DUMMY_VAR__);


            if (as_bool(logical_eq(est_sigma,1))) {

                stan::math::assign(get_base1_lhs(unalpha_tk,1,"unalpha_tk",1), add(log(p_1k),normal_log(get_base1(x_t,1,"x_t",1),mu_k,sigma_k)));
            } else {

                stan::math::assign(get_base1_lhs(unalpha_tk,1,"unalpha_tk",1), add(log(p_1k),normal_log(get_base1(x_t,1,"x_t",1),mu_k,get_base1(sigma_t,1,"sigma_t",1))));
            }
            for (int t = 2; t <= T; ++t) {

                for (int j = 1; j <= K; ++j) {

                    for (int i = 1; i <= K; ++i) {

                        if (as_bool(logical_eq(est_sigma,1))) {

                            stan::math::assign(get_base1_lhs(accumulator,i,"accumulator",1), ((get_base1(get_base1(unalpha_tk,(t - 1),"unalpha_tk",1),i,"unalpha_tk",2) + log(get_base1(get_base1(A_ij,i,"A_ij",1),j,"A_ij",2))) + normal_log(get_base1(x_t,t,"x_t",1),get_base1(mu_k,j,"mu_k",1),get_base1(sigma_k,j,"sigma_k",1))));
                        } else {

                            stan::math::assign(get_base1_lhs(accumulator,i,"accumulator",1), ((get_base1(get_base1(unalpha_tk,(t - 1),"unalpha_tk",1),i,"unalpha_tk",2) + log(get_base1(get_base1(A_ij,i,"A_ij",1),j,"A_ij",2))) + normal_log(get_base1(x_t,t,"x_t",1),get_base1(mu_k,j,"mu_k",1),get_base1(sigma_t,t,"sigma_t",1))));
                        }
                    }
                    stan::math::assign(get_base1_lhs(get_base1_lhs(unalpha_tk,t,"unalpha_tk",1),j,"unalpha_tk",2), log_sum_exp(accumulator));
                }
            }
            }

            // validate transformed parameters

            // write transformed parameters
            for (int k_1__ = 0; k_1__ < K; ++k_1__) {
                for (int k_0__ = 0; k_0__ < T; ++k_0__) {
                vars__.push_back(unalpha_tk[k_0__][k_1__]);
                }
            }

            if (!include_gqs__) return;
            // declare and define generated quantities
            validate_non_negative_index("unbeta_tk", "K", K);
            validate_non_negative_index("unbeta_tk", "T", T);
            vector<vector_d> unbeta_tk(T, (vector_d(static_cast<Eigen::VectorXd::Index>(K))));
            stan::math::initialize(unbeta_tk, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(unbeta_tk,DUMMY_VAR__);
            validate_non_negative_index("ungamma_tk", "K", K);
            validate_non_negative_index("ungamma_tk", "T", T);
            vector<vector_d> ungamma_tk(T, (vector_d(static_cast<Eigen::VectorXd::Index>(K))));
            stan::math::initialize(ungamma_tk, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(ungamma_tk,DUMMY_VAR__);
            validate_non_negative_index("alpha_tk", "K", K);
            validate_non_negative_index("alpha_tk", "T", T);
            vector<vector_d> alpha_tk(T, (vector_d(static_cast<Eigen::VectorXd::Index>(K))));
            stan::math::initialize(alpha_tk, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(alpha_tk,DUMMY_VAR__);
            validate_non_negative_index("beta_tk", "K", K);
            validate_non_negative_index("beta_tk", "T", T);
            vector<vector_d> beta_tk(T, (vector_d(static_cast<Eigen::VectorXd::Index>(K))));
            stan::math::initialize(beta_tk, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(beta_tk,DUMMY_VAR__);
            validate_non_negative_index("gamma_tk", "K", K);
            validate_non_negative_index("gamma_tk", "T", T);
            vector<vector_d> gamma_tk(T, (vector_d(static_cast<Eigen::VectorXd::Index>(K))));
            stan::math::initialize(gamma_tk, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(gamma_tk,DUMMY_VAR__);
            validate_non_negative_index("log_lik", "T", T);
            vector_d log_lik(static_cast<Eigen::VectorXd::Index>(T));
            (void) log_lik;  // dummy to suppress unused var warning

            stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(log_lik,DUMMY_VAR__);
            validate_non_negative_index("zstar_t", "T", T);
            vector<int> zstar_t(T, 0);
            stan::math::fill(zstar_t, std::numeric_limits<int>::min());
            double logp_zstar_t(0.0);
            (void) logp_zstar_t;  // dummy to suppress unused var warning

            stan::math::initialize(logp_zstar_t, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(logp_zstar_t,DUMMY_VAR__);



            for (int t = 1; t <= T; ++t) {
                stan::math::assign(get_base1_lhs(alpha_tk,t,"alpha_tk",1), softmax(get_base1(unalpha_tk,t,"unalpha_tk",1)));
            }
            {
            validate_non_negative_index("accumulator", "K", K);
            vector<double> accumulator(K, 0.0);
            stan::math::initialize(accumulator, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(accumulator,DUMMY_VAR__);


            for (int j = 1; j <= K; ++j) {
                stan::math::assign(get_base1_lhs(get_base1_lhs(unbeta_tk,T,"unbeta_tk",1),j,"unbeta_tk",2), 1);
            }
            for (int tforward = 0; tforward <= (T - 2); ++tforward) {
                {
                int t(0);
                (void) t;  // dummy to suppress unused var warning

                stan::math::fill(t, std::numeric_limits<int>::min());


                stan::math::assign(t, (T - tforward));
                for (int j = 1; j <= K; ++j) {

                    for (int i = 1; i <= K; ++i) {

                        if (as_bool(logical_eq(est_sigma,1))) {

                            stan::math::assign(get_base1_lhs(accumulator,i,"accumulator",1), ((get_base1(get_base1(unbeta_tk,t,"unbeta_tk",1),i,"unbeta_tk",2) + log(get_base1(get_base1(A_ij,j,"A_ij",1),i,"A_ij",2))) + normal_log(get_base1(x_t,t,"x_t",1),get_base1(mu_k,i,"mu_k",1),get_base1(sigma_k,i,"sigma_k",1))));
                        } else {

                            stan::math::assign(get_base1_lhs(accumulator,i,"accumulator",1), ((get_base1(get_base1(unbeta_tk,t,"unbeta_tk",1),i,"unbeta_tk",2) + log(get_base1(get_base1(A_ij,j,"A_ij",1),i,"A_ij",2))) + normal_log(get_base1(x_t,t,"x_t",1),get_base1(mu_k,i,"mu_k",1),get_base1(sigma_t,t,"sigma_t",1))));
                        }
                    }
                    stan::math::assign(get_base1_lhs(get_base1_lhs(unbeta_tk,(t - 1),"unbeta_tk",1),j,"unbeta_tk",2), log_sum_exp(accumulator));
                }
                }
            }
            for (int t = 1; t <= T; ++t) {
                stan::math::assign(get_base1_lhs(beta_tk,t,"beta_tk",1), softmax(get_base1(unbeta_tk,t,"unbeta_tk",1)));
            }
            }

            for (int t = 1; t <= T; ++t) {

                stan::math::assign(get_base1_lhs(ungamma_tk,t,"ungamma_tk",1), elt_multiply(get_base1(alpha_tk,t,"alpha_tk",1),get_base1(beta_tk,t,"beta_tk",1)));
                stan::math::assign(get_base1_lhs(gamma_tk,t,"gamma_tk",1), normalize(get_base1(ungamma_tk,t,"ungamma_tk",1), pstream__));
            }
            for (int t = 1; t <= T; ++t) {

                stan::math::assign(get_base1_lhs(log_lik,t,"log_lik",1), 0);
                for (int j = 1; j <= K; ++j) {

                    stan::math::assign(get_base1_lhs(log_lik,t,"log_lik",1), (get_base1(log_lik,t,"log_lik",1) + (get_base1(get_base1(gamma_tk,t,"gamma_tk",1),j,"gamma_tk",2) * get_base1(get_base1(alpha_tk,t,"alpha_tk",1),j,"alpha_tk",2))));
                }
                stan::math::assign(get_base1_lhs(log_lik,t,"log_lik",1), log(get_base1(log_lik,t,"log_lik",1)));
            }
            {
            validate_non_negative_index("a_tk", "T", T);
            validate_non_negative_index("a_tk", "K", K);
            vector<vector<int> > a_tk(T, (vector<int>(K, 0)));
            stan::math::fill(a_tk, std::numeric_limits<int>::min());
            validate_non_negative_index("delta_tk", "T", T);
            validate_non_negative_index("delta_tk", "K", K);
            vector<vector<double> > delta_tk(T, (vector<double>(K, 0.0)));
            stan::math::initialize(delta_tk, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(delta_tk,DUMMY_VAR__);


            if (as_bool(logical_eq(est_sigma,1))) {

                for (int j = 1; j <= K; ++j) {
                    stan::math::assign(get_base1_lhs(get_base1_lhs(delta_tk,1,"delta_tk",1),K,"delta_tk",2), normal_log(get_base1(x_t,1,"x_t",1),get_base1(mu_k,j,"mu_k",1),get_base1(sigma_k,j,"sigma_k",1)));
                }
            } else {

                for (int j = 1; j <= K; ++j) {
                    stan::math::assign(get_base1_lhs(get_base1_lhs(delta_tk,1,"delta_tk",1),K,"delta_tk",2), normal_log(get_base1(x_t,1,"x_t",1),get_base1(mu_k,j,"mu_k",1),get_base1(sigma_t,1,"sigma_t",1)));
                }
            }
            for (int t = 2; t <= T; ++t) {

                for (int j = 1; j <= K; ++j) {

                    stan::math::assign(get_base1_lhs(get_base1_lhs(delta_tk,t,"delta_tk",1),j,"delta_tk",2), stan::math::negative_infinity());
                    for (int i = 1; i <= K; ++i) {
                        {
                        double logp(0.0);
                        (void) logp;  // dummy to suppress unused var warning

                        stan::math::initialize(logp, std::numeric_limits<double>::quiet_NaN());
                        stan::math::fill(logp,DUMMY_VAR__);


                        if (as_bool(logical_eq(est_sigma,1))) {

                            stan::math::assign(logp, ((get_base1(get_base1(delta_tk,(t - 1),"delta_tk",1),i,"delta_tk",2) + log(get_base1(get_base1(A_ij,i,"A_ij",1),j,"A_ij",2))) + normal_log(get_base1(x_t,t,"x_t",1),get_base1(mu_k,j,"mu_k",1),get_base1(sigma_k,j,"sigma_k",1))));
                        } else {

                            stan::math::assign(logp, ((get_base1(get_base1(delta_tk,(t - 1),"delta_tk",1),i,"delta_tk",2) + log(get_base1(get_base1(A_ij,i,"A_ij",1),j,"A_ij",2))) + normal_log(get_base1(x_t,t,"x_t",1),get_base1(mu_k,j,"mu_k",1),get_base1(sigma_t,t,"sigma_t",1))));
                        }
                        if (as_bool(logical_gt(logp,get_base1(get_base1(delta_tk,t,"delta_tk",1),j,"delta_tk",2)))) {

                            stan::math::assign(get_base1_lhs(get_base1_lhs(a_tk,t,"a_tk",1),j,"a_tk",2), i);
                            stan::math::assign(get_base1_lhs(get_base1_lhs(delta_tk,t,"delta_tk",1),j,"delta_tk",2), logp);
                        }
                        }
                    }
                }
            }
            stan::math::assign(logp_zstar_t, max(get_base1(delta_tk,T,"delta_tk",1)));
            for (int j = 1; j <= K; ++j) {
                if (as_bool(logical_eq(get_base1(get_base1(delta_tk,T,"delta_tk",1),j,"delta_tk",2),logp_zstar_t))) {
                    stan::math::assign(get_base1_lhs(zstar_t,T,"zstar_t",1), j);
                }
            }
            for (int t = 1; t <= (T - 1); ++t) {

                stan::math::assign(get_base1_lhs(zstar_t,(T - t),"zstar_t",1), get_base1(get_base1(a_tk,((T - t) + 1),"a_tk",1),get_base1(zstar_t,((T - t) + 1),"zstar_t",1),"a_tk",2));
            }
            }

            // validate generated quantities
            for (int k0__ = 0; k0__ < T; ++k0__) {
                check_greater_or_equal(function__,"zstar_t[k0__]",zstar_t[k0__],1);
                check_less_or_equal(function__,"zstar_t[k0__]",zstar_t[k0__],K);
            }

            // write generated quantities
            for (int k_1__ = 0; k_1__ < K; ++k_1__) {
                for (int k_0__ = 0; k_0__ < T; ++k_0__) {
                vars__.push_back(unbeta_tk[k_0__][k_1__]);
                }
            }
            for (int k_1__ = 0; k_1__ < K; ++k_1__) {
                for (int k_0__ = 0; k_0__ < T; ++k_0__) {
                vars__.push_back(ungamma_tk[k_0__][k_1__]);
                }
            }
            for (int k_1__ = 0; k_1__ < K; ++k_1__) {
                for (int k_0__ = 0; k_0__ < T; ++k_0__) {
                vars__.push_back(alpha_tk[k_0__][k_1__]);
                }
            }
            for (int k_1__ = 0; k_1__ < K; ++k_1__) {
                for (int k_0__ = 0; k_0__ < T; ++k_0__) {
                vars__.push_back(beta_tk[k_0__][k_1__]);
                }
            }
            for (int k_1__ = 0; k_1__ < K; ++k_1__) {
                for (int k_0__ = 0; k_0__ < T; ++k_0__) {
                vars__.push_back(gamma_tk[k_0__][k_1__]);
                }
            }
            for (int k_0__ = 0; k_0__ < T; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < T; ++k_0__) {
            vars__.push_back(zstar_t[k_0__]);
            }
        vars__.push_back(logp_zstar_t);

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_hmm_gaussian";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p_1k" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "A_ij" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_k" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_k" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "unalpha_tk" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "unbeta_tk" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ungamma_tk" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "alpha_tk" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_tk" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "gamma_tk" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "zstar_t" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "logp_zstar_t";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= (K - 1); ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p_1k" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= (K - 1); ++k_1__) {
            for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "A_ij" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_k" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_k" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "unalpha_tk" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "unbeta_tk" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ungamma_tk" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "alpha_tk" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_tk" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= K; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "gamma_tk" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "zstar_t" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "logp_zstar_t";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

}




// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_regime_1_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_regime_1");
    reader.add_event(32, 32, "end", "model_regime_1");
    return reader;
}

class model_regime_1 : public prob_grad {
private:
    int T;
    int K;
    vector<double> x_t;
    int est_sigma;
    vector<double> sigma_t;
public:
    model_regime_1(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_regime_1(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_regime_1_namespace::model_regime_1";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            validate_non_negative_index("x_t", "T", T);
            context__.validate_dims("data initialization", "x_t", "double", context__.to_vec(T));
            validate_non_negative_index("x_t", "T", T);
            x_t = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("x_t");
            pos__ = 0;
            size_t x_t_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < x_t_limit_0__; ++i_0__) {
                x_t[i_0__] = vals_r__[pos__++];
            }
            context__.validate_dims("data initialization", "est_sigma", "int", context__.to_vec());
            est_sigma = int(0);
            vals_i__ = context__.vals_i("est_sigma");
            pos__ = 0;
            est_sigma = vals_i__[pos__++];
            validate_non_negative_index("sigma_t", "T", T);
            context__.validate_dims("data initialization", "sigma_t", "double", context__.to_vec(T));
            validate_non_negative_index("sigma_t", "T", T);
            sigma_t = std::vector<double>(T,double(0));
            vals_r__ = context__.vals_r("sigma_t");
            pos__ = 0;
            size_t sigma_t_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < sigma_t_limit_0__; ++i_0__) {
                sigma_t[i_0__] = vals_r__[pos__++];
            }

            // validate, data variables
            check_greater_or_equal(function__,"T",T,1);
            check_greater_or_equal(function__,"K",K,1);
            check_greater_or_equal(function__,"est_sigma",est_sigma,0);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            ++num_params_r__;
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_regime_1() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_k")))
            throw std::runtime_error("variable mu_k missing");
        vals_r__ = context__.vals_r("mu_k");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_k", "double", context__.to_vec());
        double mu_k(0);
        mu_k = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(mu_k);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_k: ") + e.what());
        }

        if (!(context__.contains_r("sigma_k")))
            throw std::runtime_error("variable sigma_k missing");
        vals_r__ = context__.vals_r("sigma_k");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_k", "double", context__.to_vec());
        double sigma_k(0);
        sigma_k = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_k);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_k: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            T__ mu_k;
            (void) mu_k;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_k = in__.scalar_constrain(lp__);
            else
                mu_k = in__.scalar_constrain();

            T__ sigma_k;
            (void) sigma_k;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_k = in__.scalar_lb_constrain(0,lp__);
            else
                sigma_k = in__.scalar_lb_constrain(0);


            // transformed parameters
            validate_non_negative_index("sigmas", "T", T);
            vector<T__> sigmas(T);
            stan::math::initialize(sigmas, DUMMY_VAR__);
            stan::math::fill(sigmas,DUMMY_VAR__);


            if (as_bool(logical_eq(est_sigma,1))) {

                for (int i = 1; i <= T; ++i) {
                    stan::math::assign(get_base1_lhs(sigmas,i,"sigmas",1), sigma_k);
                }
            } else {

                for (int i = 1; i <= T; ++i) {
                    stan::math::assign(get_base1_lhs(sigmas,i,"sigmas",1), get_base1(sigma_t,i,"sigma_t",1));
                }
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < T; ++i0__) {
                if (stan::math::is_uninitialized(sigmas[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: sigmas" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            // model body

            lp_accum__.add(student_t_log<propto__>(mu_k, 3, 0, 3));
            lp_accum__.add(student_t_log<propto__>(sigma_k, 3, 0, 1));
            lp_accum__.add(normal_log<propto__>(x_t, mu_k, sigmas));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_k");
        names__.push_back("sigma_k");
        names__.push_back("sigmas");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_regime_1_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double mu_k = in__.scalar_constrain();
        double sigma_k = in__.scalar_lb_constrain(0);
        vars__.push_back(mu_k);
        vars__.push_back(sigma_k);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            validate_non_negative_index("sigmas", "T", T);
            vector<double> sigmas(T, 0.0);
            stan::math::initialize(sigmas, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(sigmas,DUMMY_VAR__);


            if (as_bool(logical_eq(est_sigma,1))) {

                for (int i = 1; i <= T; ++i) {
                    stan::math::assign(get_base1_lhs(sigmas,i,"sigmas",1), sigma_k);
                }
            } else {

                for (int i = 1; i <= T; ++i) {
                    stan::math::assign(get_base1_lhs(sigmas,i,"sigmas",1), get_base1(sigma_t,i,"sigma_t",1));
                }
            }

            // validate transformed parameters

            // write transformed parameters
            for (int k_0__ = 0; k_0__ < T; ++k_0__) {
            vars__.push_back(sigmas[k_0__]);
            }

            if (!include_gqs__) return;
            // declare and define generated quantities
            validate_non_negative_index("log_lik", "T", T);
            vector_d log_lik(static_cast<Eigen::VectorXd::Index>(T));
            (void) log_lik;  // dummy to suppress unused var warning

            stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(log_lik,DUMMY_VAR__);


            for (int n = 1; n <= T; ++n) {

                stan::math::assign(get_base1_lhs(log_lik,n,"log_lik",1), normal_log(get_base1(x_t,n,"x_t",1),mu_k,get_base1(sigmas,n,"sigmas",1)));
            }

            // validate generated quantities

            // write generated quantities
            for (int k_0__ = 0; k_0__ < T; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_regime_1";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_k";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigmas" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_k";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigmas" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= T; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

}




#endif
