% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lopodSummary.R
\name{lopodSummary}
\alias{lopodSummary}
\title{Summary statistics for a LopodModel}
\usage{
lopodSummary(LopodModel, params = NULL, probs = c(0.05, 0.5, 0.95))
}
\arguments{
\item{LopodModel}{A LopodModel object}

\item{params}{Parameters to be plotted. Default is NULL, which plots all global parameters}

\item{probs}{Quantiles to be estimated}
}
\value{
Returns a dataframe which contain summaries for  all chains merged for the Global Parameters of a LopodModel. Included in the summary are quantiles, means, standard deviations (sd), effective sample sizes (n_eff), Monte Carlo standard errors (se_mean) and Rhats.
}
\description{
Summary statistics for a LopodModel
}
\examples{

 \dontrun{
data("simSpRecords", package = "bayesLopod")
data("simSpSamplingEffort", package = "bayesLopod")
simSpRasters = xyToRaster(xyRecords = simSpRecords,xySamplingEffort = simSpSamplingEffort,
basemap = NULL, nrows = 50, extentExpansion = 0)
ld_Raster_adMatrix = rasterLopodData(rasterN = simSpRasters[["samplingEffort"]],
rasterY = simSpRasters[["spDetections"]], Adjacency = TRUE )
mLopodRaster = modelLopod(LopodData = ld_Raster_adMatrix, varP = TRUE, q = NULL,
pmin = 0.1, CAR = FALSE, nChains = 4,warmup = 500,sampling = 100,nCores = 4)
lopodSummary(mLopodRaster, params = c("psi","p","q"))

data("Andropogon_shape", package = "bayesLopod")
ld_Shape = shapeLopodData(Shapefile = Andropogon_shape, fieldN = "sampEffort",
fieldY = "detections",  Adjacency = TRUE, keepFields = FALSE)
mLopodShape = modelLopod(LopodData = ld_Shape, varP = TRUE, q = NULL,
pmin = 0, CAR = TRUE, nChains = 4,warmup = 500,sampling = 100,nCores =4)
lopodSummary(mLopodRaster)
}
}
