% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Algorithm.R
\name{addAlgorithm}
\alias{addAlgorithm}
\alias{Algorithm}
\alias{removeAlgorithms}
\alias{getAlgorithmIds}
\title{Define Algorithms for Experiments}
\usage{
addAlgorithm(name, fun = NULL, reg = getDefaultRegistry())

removeAlgorithms(name, reg = getDefaultRegistry())

getAlgorithmIds(reg = getDefaultRegistry())
}
\arguments{
\item{name}{[\code{character(1)}]\cr
Unique identifier for the algorithm.}

\item{fun}{[\code{function}]\cr
  The algorithm function. The static problem part is passed as \dQuote{data}, the generated
  problem instance is passed as \dQuote{instance} and the \code{\link{Job}}/\code{\link{Experiment}} as \dQuote{job}.
  Therefore, your function must have the formal arguments \dQuote{job}, \dQuote{data} and \dQuote{instance} (or dots \code{...}).

  If you do not provide a function, it defaults to a function which just returns the instance.}

\item{reg}{[\code{\link{ExperimentRegistry}}]\cr
Registry. If not explicitly passed, uses the last created registry.}
}
\value{
[\code{Algorithm}]. Object of class \dQuote{Algorithm}.
}
\description{
Algorithms are functions which get the code{data} part as well as the problem instance (the return value of the
function defined in \code{\link{Problem}}) and return an arbitrary R object.

This function serializes all components to the file system and registers the algorithm in the \code{\link{ExperimentRegistry}}.

\code{removeAlgorithm} removes all jobs from the registry which depend on the specific algorithm.
\code{getAlgorithmIds} can be used to retrieve the IDs of already algorithms.
}
\examples{
tmp = makeExperimentRegistry(file.dir = NA, make.default = FALSE)
addProblem("p1", fun = function(job, data) data, reg = tmp)
addProblem("p2", fun = function(job, data) job, reg = tmp)
getProblemIds(reg = tmp)

addAlgorithm("a1", fun = function(job, data, instance) instance, reg = tmp)
getAlgorithmIds(reg = tmp)

removeAlgorithms("a1", reg = tmp)
getAlgorithmIds(reg = tmp)
}
