% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runOSCommand.R
\name{runOSCommand}
\alias{runOSCommand}
\title{Run OS Commands on Local or Remote Machines}
\usage{
runOSCommand(sys.cmd, sys.args = character(0L), stdin = "",
  nodename = "localhost")
}
\arguments{
\item{sys.cmd}{[\code{character(1)}]\cr
Command to run.}

\item{sys.args}{[\code{character}]\cr
Arguments for \code{sys.cmd}.}

\item{stdin}{[\code{character(1)}]\cr
Argument passed to \code{\link[base]{system2}}.}

\item{nodename}{[\code{character(1)}]\cr
Name of the SSH node to run the command on. If set to \dQuote{localhost} (default), the command
is not piped through SSH.}
}
\value{
[\code{named list}] with \dQuote{exit.code} (integer) and \dQuote{output} (character).
}
\description{
This is a helper function to run arbitrary OS commands on local or remote machines.
The interface is similar to \code{\link[base]{system2}}, but it always returns the exit status
\emph{and} the output.
}
\examples{
\dontrun{
runOSCommand("ls")
runOSCommand("ls", "-al")
runOSCommand("notfound")
}
}
\seealso{
Other ClusterFunctionsHelper: \code{\link{cfBrewTemplate}},
  \code{\link{cfHandleUnknownSubmitError}},
  \code{\link{cfKillJob}},
  \code{\link{cfReadBrewTemplate}},
  \code{\link{makeClusterFunctions}},
  \code{\link{makeSubmitJobResult}}
}
