% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Logs.R
\name{grepLogs}
\alias{grepLogs}
\title{Grep Log Files for a Pattern}
\usage{
grepLogs(ids = NULL, pattern, ignore.case = FALSE, fixed = FALSE,
  reg = getDefaultRegistry())
}
\arguments{
\item{ids}{[\code{\link[base]{data.frame}} or \code{integer}]\cr
A \code{\link[base]{data.frame}} (or \code{\link[data.table]{data.table}})
with a column named \dQuote{job.id}.
Alternatively, you may also pass a vector of integerish job ids.
If not set, defaults to the return value of \code{\link{findStarted}}.}

\item{pattern}{[\code{character(1L)}]\cr
Regular expression or string (see \code{fixed}).}

\item{ignore.case}{[\code{logical(1L)}]\cr
If \code{TRUE} the match will be performed case insensitively.}

\item{fixed}{[\code{logical(1L)}]\cr
If \code{FALSE} (default), \code{pattern} is a regular expression and a fixed string otherwise.}

\item{reg}{[\code{\link{Registry}}]\cr
Registry. If not explicitly passed, uses the default registry (see \code{\link{setDefaultRegistry}}).}
}
\value{
[\code{\link{data.table}}] with columns \dQuote{job.id} and \dQuote{message}.
}
\description{
Crawls through log files and reports jobs with lines matching the \code{pattern}.
See \code{\link{showLog}} for an example.
}
\seealso{
Other debug: \code{\link{getErrorMessages}},
  \code{\link{getStatus}}, \code{\link{killJobs}},
  \code{\link{resetJobs}}, \code{\link{showLog}},
  \code{\link{testJob}}
}
