% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterFunctionsInteractive.R
\name{makeClusterFunctionsInteractive}
\alias{makeClusterFunctionsInteractive}
\title{ClusterFunctions for Sequential Execution in the Running R Session}
\usage{
makeClusterFunctionsInteractive(
  external = FALSE,
  write.logs = TRUE,
  fs.latency = 0
)
}
\arguments{
\item{external}{[\code{logical(1)}]\cr
If set to \code{TRUE}, jobs are started in a fresh R session instead of currently active but still
waits for its termination.
Default is \code{FALSE}.}

\item{write.logs}{[\code{logical(1)}]\cr
Sink the output to log files. Turning logging off can increase the speed of
calculations but makes it very difficult to debug.
Default is \code{TRUE}.}

\item{fs.latency}{[\code{numeric(1)}]\cr
Expected maximum latency of the file system, in seconds.
Set to a positive number for network file systems like NFS which enables more robust (but also more expensive) mechanisms to
access files and directories.
Usually safe to set to \code{0} to disable the heuristic, e.g. if you are working on a local file system.}
}
\value{
[\code{\link{ClusterFunctions}}].
}
\description{
All jobs are executed sequentially using the current R process in which \code{\link{submitJobs}} is called.
Thus, \code{submitJob} blocks the session until the job has finished.
The main use of this \code{ClusterFunctions} implementation is to test and debug programs on a local computer.

Listing jobs returns an empty vector (as no jobs can be running when you call this)
and \code{killJob} is not implemented for the same reasons.
}
\seealso{
Other ClusterFunctions: 
\code{\link{makeClusterFunctionsDocker}()},
\code{\link{makeClusterFunctionsLSF}()},
\code{\link{makeClusterFunctionsMulticore}()},
\code{\link{makeClusterFunctionsOpenLava}()},
\code{\link{makeClusterFunctionsSGE}()},
\code{\link{makeClusterFunctionsSSH}()},
\code{\link{makeClusterFunctionsSlurm}()},
\code{\link{makeClusterFunctionsSocket}()},
\code{\link{makeClusterFunctionsTORQUE}()},
\code{\link{makeClusterFunctions}()}
}
\concept{ClusterFunctions}
