% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trendline.R
\name{trendline}
\alias{trendline}
\title{Add Trendline and Show Equation to Plot}
\usage{
trendline(
  x,
  y,
  model = "line2P",
  Pvalue.corrected = TRUE,
  linecolor = "blue",
  lty = 1,
  lwd = 1,
  show.equation = TRUE,
  show.Rsquare = TRUE,
  show.pvalue = TRUE,
  Rname = 1,
  Pname = 0,
  xname = "x",
  yname = "y",
  yhat = FALSE,
  summary = TRUE,
  ePos.x = NULL,
  ePos.y = NULL,
  text.col = "black",
  eDigit = 5,
  eSize = 1,
  CI.fill = TRUE,
  CI.level = 0.95,
  CI.color = "grey90",
  CI.alpha = 1,
  CI.lty = 1,
  CI.lwd = 1,
  las = 1,
  xlab = NULL,
  ylab = NULL,
  ...
)
}
\arguments{
\item{x, y}{the x and y arguments provide the x and y coordinates for the plot. Any reasonable way of defining the coordinates is acceptable.}

\item{model}{select which model to fit. Default is "line2P". The "model" should be one of c("line2P", "line3P", "log2P", "exp2P", "exp3P", "power2P", "power3P"), their formulas are as follows:\cr "line2P": y=a*x+b \cr "line3P": y=a*x^2+b*x+c \cr "log2P": y=a*ln(x)+b \cr "exp2P": y=a*exp(b*x) \cr "exp3P": y=a*exp(b*x)+c \cr "power2P": y=a*x^b \cr "power3P": y=a*x^b+c}

\item{Pvalue.corrected}{if P-value corrected or not, the value is one of c("TRUE", "FALSE").}

\item{linecolor}{color of regression line.}

\item{lty}{line type. lty can be specified using either text c("blank","solid","dashed","dotted","dotdash","longdash","twodash") or number c(0, 1, 2, 3, 4, 5, 6). Note that lty = "solid" is identical to lty=1.}

\item{lwd}{line width. Default is 1.}

\item{show.equation}{whether to show the regression equation, the value is one of c("TRUE", "FALSE").}

\item{show.Rsquare}{whether to show the R-square, the value is one of c("TRUE", "FALSE").}

\item{show.pvalue}{whether to show the P-value, the value is one of c("TRUE", "FALSE").}

\item{Rname}{to specify the character of R-square, the value is one of c(0, 1), corresponding to c(r^2, R^2).}

\item{Pname}{to specify the character of P-value, the value is one of c(0, 1), corresponding to c(p, P).}

\item{xname}{to specify the character of "x" in equation, see Examples [case 5].}

\item{yname}{to specify the character of "y" in equation, see Examples [case 5].}

\item{yhat}{whether to add a hat symbol (^) on the top of "y" in equation. Default is FALSE.}

\item{summary}{summarizing the model fits. Default is TRUE.}

\item{ePos.x, ePos.y}{equation position. Default as ePos.x = "topleft". If no need to show equation, set ePos.x = NA. It's same as those in \code{\link[graphics]{legend}}.}

\item{text.col}{the color used for the equation text.}

\item{eDigit}{the numbers of digits for equation parameters. Default is 5.}

\item{eSize}{font size in percentage of equation. Default is 1.}

\item{CI.fill}{fill the confidence interval? (TRUE by default, see 'CI.level' to control)}

\item{CI.level}{level of confidence interval to use (0.95 by default)}

\item{CI.color}{line or fill color of confidence interval.}

\item{CI.alpha}{alpha value of fill color of confidence interval.}

\item{CI.lty}{line type of confidence interval.}

\item{CI.lwd}{line width of confidence interval.}

\item{las}{style of axis labels. (0=parallel, 1=all horizontal, 2=all perpendicular to axis, 3=all vertical)}

\item{xlab, ylab}{labels of x- and y-axis.}

\item{...}{additional parameters to \code{\link[graphics]{plot}}, such as type, main, sub, pch, col.}
}
\description{
Plot, draw regression line and confidence interval, and show regression equation, R-square and P-value,  as simple as possible,
by using different models built in the 'trendline()' function. The function includes the following models in the latest version:
"line2P" (formula as: y=a*x+b), "line3P" (y=a*x^2+b*x+c), "log2P" (y=a*ln(x)+b), "exp2P" (y=a*exp(b*x)),"exp3P" (y=a*exp(b*x)+c), "power2P" (y=a*x^b), and "power3P" (y=a*x^b+c).
Besides, the summarized result of each fitted model is also output by default.
}
\details{
The linear models (line2P, line3P, log2P) in this package are estimated by \code{\link[stats]{lm}} function, \cr while the nonlinear models (exp2P, exp3P, power2P, power3P) are estimated by \code{\link[stats]{nls}} function (i.e., least-squares method).\cr\cr The argument 'Pvalue.corrected' is only valid for non-linear regression.\cr\cr If "Pvalue.corrected = TRUE", the P-value is calculated by using "Residual Sum of Squares" and "Corrected Total Sum of Squares (i.e. sum((y-mean(y))^2))".\cr If "Pvalue.corrected = FALSE", the P-value is calculated by using "Residual Sum of Squares" and "Uncorrected Total Sum of Squares (i.e. sum(y^2))".
}
\note{
Confidence intervals for nonlinear regression (i.e., objects of class
\code{nls}) are based on the linear approximation described in Bates & Watts (2007) and Greenwell & Schubert-Kabban (2014).
}
\examples{
library(basicTrendline)
x <- c(1, 3, 6,  9,  13,   17)
y <- c(5, 8, 11, 13, 13.2, 13.5)

### [case 0]  ggplot2-like trendline by par {graphics}

par(mgp=c(1.5,0.4,0), mar=c(3,3,1,1), tck=-0.01, cex.axis=0.9)

trendline(x, y, "exp3P")

# dev.off()

### [case 1] default
trendline(x, y, model="line2P", ePos.x = "topleft", summary=TRUE, eDigit=5)

### [case 2]  draw lines of confidence interval only (set CI.fill = FALSE)
trendline(x, y, model="line3P", CI.fill = FALSE, CI.color = "black", CI.lty = 2, linecolor = "blue")

### [case 3]  draw trendliine only (set CI.color = NA)
trendline(x, y, model="log2P", ePos.x= "top", linecolor = "red", CI.color = NA)

### [case 4]  show regression equation only
trendline(x, y, model="exp2P", show.Rsquare = FALSE, show.pvalue = FALSE)

### [case 5]  specify the name of parameters in equation
# see Arguments c('xname', 'yname', 'yhat', 'Rname', 'Pname').
trendline(x, y, model="exp3P", xname="T", yname=paste(delta^15,"N"),
          yhat=FALSE, Rname=1, Pname=0, ePos.x = "bottom")

### [case 6]  change the digits, font size, and color of equation.
trendline(x, y, model="power2P", eDigit = 3, eSize = 1.4, text.col = "blue")

### [case 7]  don't show equation (set ePos.x = NA)
trendline(x, y, model="power3P", ePos.x = NA)


}
\references{
Bates, D. M., and Watts, D. G. (2007)
\emph{Nonlinear Regression Analysis and its Applications}. Wiley.

Greenwell B. M., and Schubert-Kabban, C. M. (2014)
\emph{investr: An R Package for Inverse Estimation}. The R Journal, 6(1), 90-100.
}
\seealso{
\code{\link{trendline}}, \code{\link{SSexp3P}}, \code{\link{SSpower3P}}, \code{\link[stats]{nls}}, \code{\link[stats]{selfStart}}, \code{\link[investr]{plotFit}}
}
\author{
Weiping Mei, Guangchuang Yu
}
