/*
 * Decompiled with CFR 0.152.
 */
package bartMachine;

import bartMachine.StatToolbox;
import bartMachine.TreeArrayIllustration;
import bartMachine.bartMachine_a_base;
import gnu.trove.list.array.TDoubleArrayList;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;

public abstract class bartMachine_b_hyperparams
extends bartMachine_a_base
implements Serializable {
    protected static final double YminAndYmaxHalfDiff = 0.5;
    protected static double[] samps_chi_sq_df_eq_nu_plus_n = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
    protected static int samps_chi_sq_df_eq_nu_plus_n_length;
    protected static double[] samps_std_normal;
    protected static int samps_std_normal_length;
    protected double hyper_mu_mu;
    protected double hyper_sigsq_mu;
    protected double hyper_nu = 3.0;
    protected double hyper_lambda;
    protected double hyper_k = 2.0;
    protected double hyper_q = 0.9;
    protected double alpha = 0.95;
    protected double beta = 2.0;
    protected double y_min;
    protected double y_max;
    protected double y_range_sq;
    protected Double sample_var_y;

    @Override
    public void setData(ArrayList<double[]> arrayList) {
        super.setData(arrayList);
        this.calculateHyperparameters();
    }

    protected void calculateHyperparameters() {
        this.hyper_mu_mu = 0.0;
        this.hyper_sigsq_mu = Math.pow(0.5 / (this.hyper_k * Math.sqrt(this.num_trees)), 2.0);
        if (this.sample_var_y == null) {
            this.sample_var_y = StatToolbox.sample_variance(this.y_trans);
        }
        double d = 0.0;
        ChiSquaredDistributionImpl chiSquaredDistributionImpl = new ChiSquaredDistributionImpl(this.hyper_nu);
        try {
            d = chiSquaredDistributionImpl.inverseCumulativeProbability(1.0 - this.hyper_q);
        }
        catch (MathException mathException) {
            System.err.println("Could not calculate inverse cum prob density for chi sq df = " + this.hyper_nu + " with q = " + this.hyper_q);
            System.exit(0);
        }
        this.hyper_lambda = d / this.hyper_nu * this.sample_var_y;
    }

    @Override
    protected void transformResponseVariable() {
        super.transformResponseVariable();
        this.y_min = StatToolbox.sample_minimum(this.y_orig);
        this.y_max = StatToolbox.sample_maximum(this.y_orig);
        this.y_range_sq = Math.pow(this.y_max - this.y_min, 2.0);
        for (int i = 0; i < this.n; ++i) {
            this.y_trans[i] = this.transform_y(this.y_orig[i]);
        }
    }

    public double transform_y(double d) {
        return (d - this.y_min) / (this.y_max - this.y_min) - 0.5;
    }

    public double[] un_transform_y(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = this.un_transform_y(dArray[i]);
        }
        return dArray2;
    }

    @Override
    public double un_transform_y(double d) {
        return (d + 0.5) * (this.y_max - this.y_min) + this.y_min;
    }

    public double un_transform_y(Double d) {
        if (d == null) {
            return -9999999.0;
        }
        return this.un_transform_y((double)d);
    }

    public double un_transform_sigsq(double d) {
        return d * this.y_range_sq;
    }

    public double[] un_transform_sigsq(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = this.un_transform_sigsq(dArray[i]);
        }
        return dArray2;
    }

    public double un_transform_y_and_round(double d) {
        return Double.parseDouble(TreeArrayIllustration.one_digit_format.format((d + 0.5) * (this.y_max - this.y_min) + this.y_min));
    }

    public double[] un_transform_y_and_round(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = this.un_transform_y_and_round(dArray[i]);
        }
        return dArray2;
    }

    public double[] un_transform_y_and_round(TDoubleArrayList tDoubleArrayList) {
        return this.un_transform_y_and_round(tDoubleArrayList.toArray());
    }

    public void setK(double d) {
        this.hyper_k = d;
    }

    public void setQ(double d) {
        this.hyper_q = d;
    }

    public void setNu(double d) {
        this.hyper_nu = d;
    }

    public void setAlpha(double d) {
        this.alpha = d;
    }

    public void setBeta(double d) {
        this.beta = d;
    }

    public double getHyper_mu_mu() {
        return this.hyper_mu_mu;
    }

    public double getHyper_sigsq_mu() {
        return this.hyper_sigsq_mu;
    }

    public double getHyper_nu() {
        return this.hyper_nu;
    }

    public double getHyper_lambda() {
        return this.hyper_lambda;
    }

    public double getY_min() {
        return this.y_min;
    }

    public double getY_max() {
        return this.y_max;
    }

    public double getY_range_sq() {
        return this.y_range_sq;
    }

    static {
        samps_std_normal = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
    }
}

