% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IO.R
\name{empty_file}
\alias{empty_file}
\title{detect whether file is empty recursively}
\usage{
empty_file(path, strict = FALSE)
}
\arguments{
\item{path}{the path of file}

\item{strict}{\code{FALSE} as default. If \code{TRUE}, a file with only one
character of length 0 will be considered as not empty}
}
\value{
logical value
}
\description{
detect whether file is empty recursively
}
\examples{
# create an empty directory
dir.create("some/deep/path/in/a/folder", recursive = TRUE)
empty_dir("some/deep/path/in/a/folder")

# create an empty file
file.create("some/deep/path/in/a/folder/there_is_a_file.txt")
empty_dir("some/deep/path/in/a/folder")
empty_file("some/deep/path/in/a/folder/there_is_a_file.txt", strict = TRUE)

# create a file with only character of length 0
write("", "some/deep/path/in/a/folder/there_is_a_file.txt")
empty_file("some/deep/path/in/a/folder/there_is_a_file.txt", strict = TRUE)
empty_file("some/deep/path/in/a/folder/there_is_a_file.txt")

# clean
unlink("some", recursive = TRUE)

}
